/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.AbstractMultiIndexActionBuilder;
import io.searchbox.Action;
import org.apache.commons.lang3.StringUtils;

public class SearchScroll
extends AbstractAction
implements Action {
    public SearchScroll(Builder builder) {
        super(builder);
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_search/scroll");
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    public static class Builder
    extends AbstractMultiIndexActionBuilder<SearchScroll, Builder> {
        public Builder(String scrollId, String scroll) {
            this.setParameter("scroll_id", scrollId);
            this.setParameter("scroll", scroll);
        }

        @Override
        public String getJoinedIndices() {
            if (this.indexNames.size() > 0) {
                return StringUtils.join((Iterable)this.indexNames, (String)",");
            }
            return null;
        }

        @Override
        public SearchScroll build() {
            return new SearchScroll(this);
        }
    }
}

