/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import io.searchbox.AbstractAction;
import io.searchbox.AbstractMultiTypeActionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteByQuery
extends AbstractAction {
    static final Logger log = LoggerFactory.getLogger(DeleteByQuery.class);
    private String query;

    public DeleteByQuery(Builder builder) {
        super(builder);
        this.query = builder.query;
        this.setURI(this.buildURI());
    }

    @Override
    public String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_query");
        log.debug("Created URI for delete by query action is : {}", (Object)sb.toString());
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    public String getRestMethodName() {
        return "DELETE";
    }

    @Override
    public Object getData(Gson gson) {
        return this.query;
    }

    public static class Builder
    extends AbstractMultiTypeActionBuilder<DeleteByQuery, Builder> {
        private String query;

        public Builder(String query) {
            this.query = query;
        }

        @Override
        public DeleteByQuery build() {
            return new DeleteByQuery(this);
        }
    }
}

