/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import io.searchbox.client.JestClient;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.client.config.discovery.NodeChecker;
import io.searchbox.client.http.JestHttpClient;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.reactor.IOReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestClientFactory {
    static final Logger log = LoggerFactory.getLogger(JestClientFactory.class);
    private ClientConfig clientConfig;

    public JestClient getObject() {
        JestHttpClient client = new JestHttpClient();
        if (this.clientConfig != null) {
            DefaultHttpClient httpclient;
            log.debug("Creating HTTP client based on configuration");
            client.setServers(this.clientConfig.getServerList());
            boolean isMultiThreaded = this.clientConfig.isMultiThreaded();
            if (isMultiThreaded) {
                Integer defaultMaxPerRoute;
                PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
                Integer maxTotal = this.clientConfig.getMaxTotalConnection();
                if (maxTotal != null) {
                    cm.setMaxTotal(maxTotal.intValue());
                }
                if ((defaultMaxPerRoute = this.clientConfig.getDefaultMaxTotalConnectionPerRoute()) != null) {
                    cm.setDefaultMaxPerRoute(defaultMaxPerRoute.intValue());
                }
                Map<HttpRoute, Integer> maxPerRoute = this.clientConfig.getMaxTotalConnectionPerRoute();
                for (HttpRoute route : maxPerRoute.keySet()) {
                    cm.setMaxPerRoute(route, maxPerRoute.get(route).intValue());
                }
                httpclient = new DefaultHttpClient((ClientConnectionManager)cm);
                log.debug("Multi Threaded http client created");
            } else {
                httpclient = new DefaultHttpClient();
                log.debug("Default http client is created without multi threaded option");
            }
            Gson gson = this.clientConfig.getGson();
            if (gson != null) {
                client.setGson(gson);
            }
            client.setHttpClient((HttpClient)httpclient);
            if (this.clientConfig.isDiscoveryEnabled()) {
                log.info("Node Discovery Enabled...");
                NodeChecker nodeChecker = new NodeChecker(this.clientConfig, client);
                client.setNodeChecker(nodeChecker);
                nodeChecker.startAndWait();
            } else {
                log.info("Node Discovery Disabled...");
            }
        } else {
            log.debug("There is no configuration to create http client. Going to create simple client with default values");
            client.setHttpClient((HttpClient)new DefaultHttpClient());
            LinkedHashSet<String> servers = new LinkedHashSet<String>();
            servers.add("http://localhost:9200");
            client.setServers(servers);
        }
        try {
            client.setAsyncClient((HttpAsyncClient)new DefaultHttpAsyncClient());
        }
        catch (IOReactorException e) {
            log.error("Cannot set asynchronous http client to jest client. Exception occurred:" + e.getMessage());
        }
        return client;
    }

    public Class<?> getObjectType() {
        return JestClient.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setClientConfig(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }
}

