/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox;

import io.searchbox.AbstractAction;
import io.searchbox.Action;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractMultiIndexActionBuilder<T extends Action, K>
extends AbstractAction.Builder<T, K> {
    protected Set<String> indexNames = new HashSet<String>();

    public K addIndex(String indexName) {
        this.indexNames.add(indexName);
        return (K)this;
    }

    public K addIndex(Collection<? extends String> indexNames) {
        this.indexNames.addAll(indexNames);
        return (K)this;
    }

    public K ignoreIndices(String ignoreIndices) {
        this.setParameter("ignore_indices", null);
        return (K)this;
    }

    public String getJoinedIndices() {
        if (this.indexNames.size() > 0) {
            return StringUtils.join(this.indexNames, (String)",");
        }
        return "_all";
    }

    @Override
    public abstract T build();
}

