/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.searchbox.client.JestResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SuggestResult
extends JestResult {
    public SuggestResult(SuggestResult suggestResult) {
        super(suggestResult);
    }

    public SuggestResult(Gson gson) {
        super(gson);
    }

    public List<Suggestion> getSuggestions(String suggestionName) {
        ArrayList<Suggestion> suggestions = new ArrayList<Suggestion>();
        if (this.jsonObject != null && this.jsonObject.has(suggestionName)) {
            for (JsonElement suggestionElement : this.jsonObject.getAsJsonArray(suggestionName)) {
                suggestions.add(this.gson.fromJson(suggestionElement, Suggestion.class));
            }
        }
        return suggestions;
    }

    public class Suggestion {
        public final String text;
        public final Integer offset;
        public final Integer length;
        public final List<Map<String, Object>> options;

        public Suggestion(String text, Integer offset, Integer length, List<Map<String, Object>> options) {
            this.text = text;
            this.offset = offset;
            this.length = length;
            this.options = options;
        }

        public int hashCode() {
            return Objects.hash(this.text, this.offset, this.length, this.options);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Suggestion rhs = (Suggestion)obj;
            return Objects.equals(this.text, rhs.text) && Objects.equals(this.offset, rhs.offset) && Objects.equals(this.length, rhs.length) && Objects.equals(this.options, rhs.options);
        }
    }
}

