/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Doc {
    private final String index;
    private final String type;
    private final String id;
    private String routing;
    private Object source;
    private final Collection<String> fields = new LinkedList<String>();

    public Doc(String index, String id) {
        this(index, null, id);
    }

    public Doc(String index, String type, String id) {
        if (StringUtils.isEmpty(index)) {
            throw new IllegalArgumentException("Required Index argument cannot be null or empty.");
        }
        if (StringUtils.isEmpty(id)) {
            throw new IllegalArgumentException("Required Id argument cannot be null or empty.");
        }
        this.index = index;
        this.type = type;
        this.id = id;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Collection<String> getFields() {
        return this.fields;
    }

    public void addFields(Collection<String> fields) {
        this.fields.addAll(fields);
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    protected Map<String, Object> toMap() {
        LinkedHashMap<String, Object> retval = new LinkedHashMap<String, Object>();
        retval.put("_index", this.index);
        if (StringUtils.isNotEmpty(this.type)) {
            retval.put("_type", this.type);
        }
        retval.put("_id", this.id);
        if (!this.fields.isEmpty()) {
            retval.put("fields", this.fields);
        }
        if (StringUtils.isNotEmpty(this.routing)) {
            retval.put("_routing", this.routing);
        }
        if (this.source != null) {
            retval.put("_source", this.source);
        }
        return retval;
    }
}

