/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.collect.ImmutableMap;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.GenericResultAbstractAction;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class ClearScroll
extends GenericResultAbstractAction {
    private final String uri;

    public ClearScroll(Builder builder) {
        if (builder.getScrollIds().size() == 0) {
            this.uri = "/_search/scroll/_all";
            this.payload = null;
        } else {
            this.uri = "/_search/scroll";
            this.payload = ImmutableMap.of("scroll_id", builder.getScrollIds());
        }
        this.setURI(this.buildURI());
    }

    @Override
    public String getRestMethodName() {
        return "DELETE";
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + this.uri;
    }

    public static class Builder
    extends AbstractAction.Builder<ClearScroll, Builder> {
        protected Collection<String> scrollIds = new LinkedHashSet<String>();

        public Builder addScrollId(String scrollId) {
            this.scrollIds.add(scrollId);
            return this;
        }

        public Builder addScrollIds(Set<String> scrollIds) {
            this.scrollIds.addAll(scrollIds);
            return this;
        }

        @Override
        public ClearScroll build() {
            return new ClearScroll(this);
        }

        public Collection<String> getScrollIds() {
            return this.scrollIds;
        }
    }
}

