/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BulkResult
extends JestResult {
    public BulkResult(JestResult source) {
        super(source);
    }

    public BulkResult(Gson gson) {
        super(gson);
    }

    public List<BulkResultItem> getItems() {
        LinkedList<BulkResultItem> items = new LinkedList<BulkResultItem>();
        if (this.jsonObject != null && this.jsonObject.has("items")) {
            for (JsonElement jsonElement : this.jsonObject.getAsJsonArray("items")) {
                for (Map.Entry<String, JsonElement> entry : jsonElement.getAsJsonObject().entrySet()) {
                    items.add(new BulkResultItem(entry.getKey(), entry.getValue().getAsJsonObject()));
                }
            }
        }
        return items;
    }

    public List<BulkResultItem> getFailedItems() {
        LinkedList<BulkResultItem> items = new LinkedList<BulkResultItem>();
        if (this.jsonObject != null && this.jsonObject.has("items")) {
            for (JsonElement jsonElement : this.jsonObject.getAsJsonArray("items")) {
                for (Map.Entry<String, JsonElement> entry : jsonElement.getAsJsonObject().entrySet()) {
                    JsonObject values = entry.getValue().getAsJsonObject();
                    if (!values.has("error")) continue;
                    items.add(new BulkResultItem(entry.getKey(), values));
                }
            }
        }
        return items;
    }

    public class BulkResultItem {
        public final String operation;
        public final String index;
        public final String type;
        public final String id;
        public final int status;
        public final String error;

        public BulkResultItem(String operation, String index, String type, String id, int status, String error) {
            this.operation = operation;
            this.index = index;
            this.type = type;
            this.id = id;
            this.status = status;
            this.error = error;
        }

        public BulkResultItem(String operation, JsonObject values) {
            this.operation = operation;
            this.index = values.get("_index").getAsString();
            this.type = values.get("_type").getAsString();
            this.id = values.get("_id").getAsString();
            this.status = values.get("status").getAsInt();
            this.error = values.has("error") ? values.get("error").toString() : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BulkResultItem that = (BulkResultItem)o;
            return new EqualsBuilder().append(this.status, that.status).append(this.operation, that.operation).append(this.index, that.index).append(this.type, that.type).append(this.id, that.id).append(this.error, that.error).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.operation).append(this.index).append(this.type).append(this.id).append(this.status).append(this.error).toHashCode();
        }
    }
}

