/*
 * Decompiled with CFR 0.152.
 */
package com.searchly.jestdroid;

import com.google.gson.Gson;
import com.searchly.jestdroid.http.HttpDeleteWithEntity;
import com.searchly.jestdroid.http.HttpGetWithEntity;
import io.searchbox.action.Action;
import io.searchbox.client.AbstractJestClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpHeadHC4;
import org.apache.http.client.methods.HttpPostHC4;
import org.apache.http.client.methods.HttpPutHC4;
import org.apache.http.client.methods.HttpRequestBaseHC4;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtilsHC4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestDroidClient
extends AbstractJestClient
implements JestClient {
    private static final Logger log = LoggerFactory.getLogger(JestDroidClient.class);
    protected ContentType requestContentType = ContentType.APPLICATION_JSON.withCharset("utf-8");
    private HttpClient httpClient;

    @Override
    public <T extends JestResult> T execute(Action<T> clientRequest) throws IOException {
        String elasticSearchRestUrl = this.getRequestURL(this.getNextServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData(this.gson));
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue().toString());
            }
        }
        HttpResponse response = this.httpClient.execute(request);
        return this.deserializeResponse(response, clientRequest);
    }

    @Override
    public <T extends JestResult> void executeAsync(Action<T> clientRequest, JestResultHandler<? super T> resultHandler) {
        throw new UnsupportedOperationException("Jest-droid does not yet support async execution, sorry!");
    }

    @Override
    public void shutdownClient() {
        super.shutdownClient();
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, String payload) {
        HttpRequestBaseHC4 httpUriRequest = null;
        if (methodName.equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPostHC4(url);
            log.debug("POST method created based on client request");
        } else if (methodName.equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPutHC4(url);
            log.debug("PUT method created based on client request");
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            httpUriRequest = new HttpDeleteWithEntity(url);
            log.debug("DELETE method created based on client request");
        } else if (methodName.equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGetWithEntity(url);
            log.debug("GET method created based on client request");
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHeadHC4(url);
            log.debug("HEAD method created based on client request");
        }
        if (httpUriRequest != null && httpUriRequest instanceof HttpEntityEnclosingRequest && payload != null) {
            EntityBuilder entityBuilder = EntityBuilder.create().setText(payload).setContentType(this.requestContentType);
            if (this.isRequestCompressionEnabled()) {
                entityBuilder.gzipCompress();
            }
            ((HttpEntityEnclosingRequest)httpUriRequest).setEntity(entityBuilder.build());
        }
        return httpUriRequest;
    }

    private <T extends JestResult> T deserializeResponse(HttpResponse response, Action<T> clientRequest) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        return clientRequest.createNewElasticSearchResult(response.getEntity() != null ? EntityUtilsHC4.toString(response.getEntity()) : null, statusLine.getStatusCode(), statusLine.getReasonPhrase(), this.gson);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

