/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import android.util.Log;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

class AndroidLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = -1227274521521287937L;

    AndroidLoggerAdapter(String tag) {
        this.name = tag;
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(2);
    }

    public void trace(String msg) {
        this.log(2, msg, null);
    }

    public void trace(String format, Object arg) {
        this.formatAndLog(2, format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.formatAndLog(2, format, arg1, arg2);
    }

    public void trace(String format, Object ... argArray) {
        this.formatAndLog(2, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        this.log(2, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(3);
    }

    public void debug(String msg) {
        this.log(3, msg, null);
    }

    public void debug(String format, Object arg) {
        this.formatAndLog(3, format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.formatAndLog(3, format, arg1, arg2);
    }

    public void debug(String format, Object ... argArray) {
        this.formatAndLog(3, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        this.log(2, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(4);
    }

    public void info(String msg) {
        this.log(4, msg, null);
    }

    public void info(String format, Object arg) {
        this.formatAndLog(4, format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.formatAndLog(4, format, arg1, arg2);
    }

    public void info(String format, Object ... argArray) {
        this.formatAndLog(4, format, argArray);
    }

    public void info(String msg, Throwable t) {
        this.log(4, msg, t);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(5);
    }

    public void warn(String msg) {
        this.log(5, msg, null);
    }

    public void warn(String format, Object arg) {
        this.formatAndLog(5, format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.formatAndLog(5, format, arg1, arg2);
    }

    public void warn(String format, Object ... argArray) {
        this.formatAndLog(5, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        this.log(5, msg, t);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(6);
    }

    public void error(String msg) {
        this.log(6, msg, null);
    }

    public void error(String format, Object arg) {
        this.formatAndLog(6, format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.formatAndLog(6, format, arg1, arg2);
    }

    public void error(String format, Object ... argArray) {
        this.formatAndLog(6, format, argArray);
    }

    public void error(String msg, Throwable t) {
        this.log(6, msg, t);
    }

    private void formatAndLog(int priority, String format, Object ... argArray) {
        if (this.isLoggable(priority)) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, argArray);
            this._log(priority, ft.getMessage(), ft.getThrowable());
        }
    }

    private void log(int priority, String message, Throwable throwable) {
        if (this.isLoggable(priority)) {
            this._log(priority, message, throwable);
        }
    }

    private boolean isLoggable(int priority) {
        return Log.isLoggable((String)this.name, (int)priority);
    }

    private void _log(int priority, String message, Throwable throwable) {
        if (throwable != null) {
            message = message + '\n' + Log.getStackTraceString((Throwable)throwable);
        }
        Log.println((int)priority, (String)this.name, (String)message);
    }
}

