/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import io.searchbox.action.AbstractMultiIndexActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;
import org.apache.commons.lang3.StringUtils;

public class SearchScroll
extends GenericResultAbstractAction {
    @VisibleForTesting
    static final int MAX_SCROLL_ID_LENGTH = 1900;
    private final String scrollId;

    public SearchScroll(Builder builder) {
        super(builder);
        this.scrollId = builder.getScrollId();
        this.setURI(this.buildURI());
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_search/scroll");
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return this.scrollId.length() > 1900 ? "POST" : "GET";
    }

    @Override
    public Object getData(Gson gson) {
        return this.scrollId.length() > 1900 ? this.scrollId : super.getData(gson);
    }

    @Override
    public String getPathToResult() {
        return "hits/hits/_source";
    }

    public static class Builder
    extends AbstractMultiIndexActionBuilder<SearchScroll, Builder> {
        private final String scrollId;

        public Builder(String scrollId, String scroll) {
            this.scrollId = scrollId;
            if (scrollId.length() <= 1900) {
                this.setParameter("scroll_id", scrollId);
            }
            this.setParameter("scroll", scroll);
        }

        @Override
        public String getJoinedIndices() {
            if (this.indexNames.size() > 0) {
                return StringUtils.join(this.indexNames, ",");
            }
            return null;
        }

        @Override
        public SearchScroll build() {
            return new SearchScroll(this);
        }

        public String getScrollId() {
            return this.scrollId;
        }
    }
}

