/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.AbstractMultiTypeActionBuilder;
import io.searchbox.action.GenericResultAbstractAction;
import io.searchbox.core.Doc;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class MultiGet
extends GenericResultAbstractAction {
    private Object source;

    protected MultiGet(AbstractAction.Builder builder) {
        super(builder);
        this.setBulkOperation(true);
        this.setURI(this.buildURI());
        this.setPathToResult("docs/_source");
    }

    public MultiGet(Builder.ByDoc builder) {
        this((AbstractAction.Builder)builder);
        this.source = ImmutableMap.of("docs", this.docsToMaps(builder.docs));
    }

    public MultiGet(Builder.ById builder) {
        this((AbstractAction.Builder)builder);
        this.source = ImmutableMap.of("ids", builder.ids);
    }

    @Override
    public Object getData(Gson gson) {
        return gson.toJson(this.source);
    }

    protected Object docsToMaps(List<Doc> docs) {
        return Lists.transform(docs, new Function<Doc, Object>(){

            @Override
            public Object apply(Doc doc) {
                return doc.toMap();
            }
        });
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_mget");
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "GET";
    }

    public static class Builder {
        private Builder() {
        }

        public static class ByDoc
        extends AbstractAction.Builder<MultiGet, ByDoc> {
            private List<Doc> docs = new LinkedList<Doc>();

            public ByDoc(Collection<? extends Doc> docs) {
                this.docs.addAll(docs);
            }

            public ByDoc(Doc doc) {
                this.docs.add(doc);
            }

            public ByDoc addDoc(Collection<? extends Doc> docs) {
                this.docs.addAll(docs);
                return this;
            }

            public ByDoc addDoc(Doc doc) {
                this.docs.add(doc);
                return this;
            }

            @Override
            public MultiGet build() {
                return new MultiGet(this);
            }
        }

        public static class ById
        extends AbstractMultiTypeActionBuilder<MultiGet, ById> {
            private List<String> ids = new LinkedList<String>();

            public ById(String index, String type) {
                this.addIndex(index);
                this.addType(type);
            }

            public ById addId(Collection<? extends String> ids) {
                this.ids.addAll(ids);
                return this;
            }

            public ById addId(String id) {
                this.ids.add(id);
                return this;
            }

            @Override
            public MultiGet build() {
                return new MultiGet(this);
            }
        }
    }
}

