/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.ThreadSafe;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheStorage;
import ch.boye.httpclientandroidlib.impl.client.cache.CacheKeyGenerator;
import ch.boye.httpclientandroidlib.impl.cookie.DateParseException;
import ch.boye.httpclientandroidlib.impl.cookie.DateUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

@ThreadSafe
class CacheInvalidator {
    private final HttpCacheStorage storage;
    private final CacheKeyGenerator cacheKeyGenerator;
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public CacheInvalidator(CacheKeyGenerator uriExtractor, HttpCacheStorage storage) {
        this.cacheKeyGenerator = uriExtractor;
        this.storage = storage;
    }

    public void flushInvalidatedCacheEntries(HttpHost host, HttpRequest req) {
        if (this.requestShouldNotBeCached(req)) {
            Header lHdr;
            String contentLocation;
            URL reqURL;
            this.log.debug("Request should not be cached");
            String theUri = this.cacheKeyGenerator.getURI(host, req);
            HttpCacheEntry parent = this.getEntry(theUri);
            this.log.debug("parent entry: " + parent);
            if (parent != null) {
                for (String variantURI : parent.getVariantMap().values()) {
                    this.flushEntry(variantURI);
                }
                this.flushEntry(theUri);
            }
            if ((reqURL = this.getAbsoluteURL(theUri)) == null) {
                this.log.error("Couldn't transform request into valid URL");
                return;
            }
            Header clHdr = req.getFirstHeader("Content-Location");
            if (clHdr != null && !this.flushAbsoluteUriFromSameHost(reqURL, contentLocation = clHdr.getValue())) {
                this.flushRelativeUriFromSameHost(reqURL, contentLocation);
            }
            if ((lHdr = req.getFirstHeader("Location")) != null) {
                this.flushAbsoluteUriFromSameHost(reqURL, lHdr.getValue());
            }
        }
    }

    private void flushEntry(String uri) {
        try {
            this.storage.removeEntry(uri);
        }
        catch (IOException ioe) {
            this.log.warn("unable to flush cache entry", ioe);
        }
    }

    private HttpCacheEntry getEntry(String theUri) {
        try {
            return this.storage.getEntry(theUri);
        }
        catch (IOException ioe) {
            this.log.warn("could not retrieve entry from storage", ioe);
            return null;
        }
    }

    protected void flushUriIfSameHost(URL requestURL, URL targetURL) {
        URL canonicalTarget = this.getAbsoluteURL(this.cacheKeyGenerator.canonicalizeUri(targetURL.toString()));
        if (canonicalTarget == null) {
            return;
        }
        if (canonicalTarget.getAuthority().equalsIgnoreCase(requestURL.getAuthority())) {
            this.flushEntry(canonicalTarget.toString());
        }
    }

    protected void flushRelativeUriFromSameHost(URL reqURL, String relUri) {
        URL relURL = this.getRelativeURL(reqURL, relUri);
        if (relURL == null) {
            return;
        }
        this.flushUriIfSameHost(reqURL, relURL);
    }

    protected boolean flushAbsoluteUriFromSameHost(URL reqURL, String uri) {
        URL absURL = this.getAbsoluteURL(uri);
        if (absURL == null) {
            return false;
        }
        this.flushUriIfSameHost(reqURL, absURL);
        return true;
    }

    private URL getAbsoluteURL(String uri) {
        URL absURL = null;
        try {
            absURL = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return absURL;
    }

    private URL getRelativeURL(URL reqURL, String relUri) {
        URL relURL = null;
        try {
            relURL = new URL(reqURL, relUri);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return relURL;
    }

    protected boolean requestShouldNotBeCached(HttpRequest req) {
        String method = req.getRequestLine().getMethod();
        return this.notGetOrHeadRequest(method);
    }

    private boolean notGetOrHeadRequest(String method) {
        return !"GET".equals(method) && !"HEAD".equals(method);
    }

    public void flushInvalidatedCacheEntries(HttpHost host, HttpRequest request, HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        if (status < 200 || status > 299) {
            return;
        }
        URL reqURL = this.getAbsoluteURL(this.cacheKeyGenerator.getURI(host, request));
        if (reqURL == null) {
            return;
        }
        URL canonURL = this.getContentLocationURL(reqURL, response);
        if (canonURL == null) {
            return;
        }
        String cacheKey = this.cacheKeyGenerator.canonicalizeUri(canonURL.toString());
        HttpCacheEntry entry = this.getEntry(cacheKey);
        if (entry == null) {
            return;
        }
        if (this.responseDateOlderThanEntryDate(response, entry)) {
            return;
        }
        if (!this.responseAndEntryEtagsDiffer(response, entry)) {
            return;
        }
        this.flushUriIfSameHost(reqURL, canonURL);
    }

    private URL getContentLocationURL(URL reqURL, HttpResponse response) {
        Header clHeader = response.getFirstHeader("Content-Location");
        if (clHeader == null) {
            return null;
        }
        String contentLocation = clHeader.getValue();
        URL canonURL = this.getAbsoluteURL(contentLocation);
        if (canonURL != null) {
            return canonURL;
        }
        return this.getRelativeURL(reqURL, contentLocation);
    }

    private boolean responseAndEntryEtagsDiffer(HttpResponse response, HttpCacheEntry entry) {
        Header entryEtag = entry.getFirstHeader("ETag");
        Header responseEtag = response.getFirstHeader("ETag");
        if (entryEtag == null || responseEtag == null) {
            return false;
        }
        return !entryEtag.getValue().equals(responseEtag.getValue());
    }

    private boolean responseDateOlderThanEntryDate(HttpResponse response, HttpCacheEntry entry) {
        Header entryDateHeader = entry.getFirstHeader("Date");
        Header responseDateHeader = response.getFirstHeader("Date");
        if (entryDateHeader == null || responseDateHeader == null) {
            return false;
        }
        try {
            Date entryDate = DateUtils.parseDate(entryDateHeader.getValue());
            Date responseDate = DateUtils.parseDate(responseDateHeader.getValue());
            return responseDate.before(entryDate);
        }
        catch (DateParseException e) {
            return false;
        }
    }
}

