/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.client.cache;

import ch.boye.httpclientandroidlib.HttpHost;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.ProtocolException;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.client.cache.HttpCacheEntry;
import ch.boye.httpclientandroidlib.impl.client.cache.AsynchronousValidator;
import ch.boye.httpclientandroidlib.impl.client.cache.CachingHttpClient;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;

class AsynchronousValidationRequest
implements Runnable {
    private final AsynchronousValidator parent;
    private final CachingHttpClient cachingClient;
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpContext context;
    private final HttpCacheEntry cacheEntry;
    private final String identifier;
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    AsynchronousValidationRequest(AsynchronousValidator parent, CachingHttpClient cachingClient, HttpHost target, HttpRequest request, HttpContext context, HttpCacheEntry cacheEntry, String identifier) {
        this.parent = parent;
        this.cachingClient = cachingClient;
        this.target = target;
        this.request = request;
        this.context = context;
        this.cacheEntry = cacheEntry;
        this.identifier = identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.cachingClient.revalidateCacheEntry(this.target, this.request, this.context, this.cacheEntry);
        }
        catch (IOException ioe) {
            this.log.debug("Asynchronous revalidation failed due to exception: " + ioe);
        }
        catch (ProtocolException pe) {
            this.log.error("ProtocolException thrown during asynchronous revalidation: " + pe);
        }
        finally {
            this.parent.markComplete(this.identifier);
        }
    }

    String getIdentifier() {
        return this.identifier;
    }
}

