/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.searchbox.AbstractAction;
import io.searchbox.AbstractDocumentTargetedAction;
import io.searchbox.BulkableAction;
import java.util.Collection;

public class Index
extends AbstractDocumentTargetedAction
implements BulkableAction {
    private Object source;

    private Index(Builder builder) {
        super(builder);
        this.source = builder.source;
        this.setURI(this.buildURI());
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    public Boolean isOperationSucceed(JsonObject result) {
        return result.get("ok").getAsBoolean();
    }

    @Override
    public String getRestMethodName() {
        return this.id != null ? "PUT" : "POST";
    }

    @Override
    public Object getData(Gson gson) {
        return this.source;
    }

    @Override
    public String getBulkMethodName() {
        Collection<Object> opType = this.getParameter("op_type");
        if (opType != null) {
            if (opType.size() > 1) {
                throw new IllegalArgumentException("Expecting a single value for OP_TYPE parameter, you provided: " + opType.size());
            }
            return opType.size() == 1 && opType.iterator().next().toString().equalsIgnoreCase("create") ? "create" : "index";
        }
        return "index";
    }

    public static class Builder
    extends AbstractDocumentTargetedAction.Builder<Index, Builder> {
        private final Object source;

        public Builder(Object source) {
            this.source = source;
            this.id(AbstractAction.getIdFromSource(source));
        }

        @Override
        public Index build() {
            return new Index(this);
        }
    }
}

