/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client.config.discovery;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.ClientConfig;
import io.searchbox.cluster.NodesInfo;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeChecker
extends AbstractScheduledService {
    static final Logger logger = LoggerFactory.getLogger(NodeChecker.class);
    JestClient client;
    ClientConfig clientConfig;

    public NodeChecker(ClientConfig clientConfig, JestClient jestClient) {
        this.client = jestClient;
        this.clientConfig = clientConfig;
    }

    @Override
    protected void runOneIteration() throws Exception {
        JestResult result;
        NodesInfo action = new NodesInfo.Builder().build();
        try {
            result = this.client.execute(action);
        }
        catch (Exception e) {
            logger.error("Error executing NodesInfo!", e);
            throw new RuntimeException("Error executing NodesInfo!", e);
        }
        LinkedHashSet<String> httpHosts = new LinkedHashSet<String>();
        JsonObject jsonMap = result.getJsonObject();
        JsonObject nodes = (JsonObject)jsonMap.get("nodes");
        if (nodes != null) {
            for (Map.Entry<String, JsonElement> entry : nodes.entrySet()) {
                JsonObject host = (JsonObject)entry.getValue();
                String http_address = host.get("http_address").getAsString();
                if (null == http_address) continue;
                String cleanHttpAddress = "http://" + http_address.substring(6, http_address.length() - 1);
                httpHosts.add(cleanHttpAddress);
            }
        }
        logger.info("Discovered Http Hosts: {}", httpHosts);
        this.client.setServers(httpHosts);
    }

    @Override
    protected AbstractScheduledService.Scheduler scheduler() {
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule(0L, this.clientConfig.getDiscoveryFrequency(), this.clientConfig.getDiscoveryFrequencyTimeUnit());
    }
}

