/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.AbstractMultiINodeActionBuilder;
import io.searchbox.AbstractMultiIndexActionBuilder;
import io.searchbox.AbstractMultiTypeActionBuilder;
import io.searchbox.Action;
import io.searchbox.annotations.JestId;
import io.searchbox.core.Doc;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(AbstractAction.class);
    public static String CHARSET = "utf-8";
    private final ConcurrentMap<String, Object> headerMap = new ConcurrentHashMap<String, Object>();
    private final Multimap<String, Object> parameterMap = HashMultimap.create();
    protected String indexName;
    protected String typeName;
    protected String nodes;
    private String URI;
    private boolean isBulkOperation;
    private String pathToResult;

    public AbstractAction() {
    }

    public AbstractAction(Builder builder) {
        this.parameterMap.putAll(builder.parameters);
        this.headerMap.putAll(builder.headers);
        if (builder instanceof AbstractMultiIndexActionBuilder) {
            this.indexName = ((AbstractMultiIndexActionBuilder)builder).getJoinedIndices();
            if (builder instanceof AbstractMultiTypeActionBuilder) {
                this.indexName = ((AbstractMultiTypeActionBuilder)builder).getJoinedIndices();
                this.typeName = ((AbstractMultiTypeActionBuilder)builder).getJoinedTypes();
            }
        } else if (builder instanceof AbstractMultiINodeActionBuilder) {
            this.nodes = ((AbstractMultiINodeActionBuilder)builder).getJoinedNodes();
        }
    }

    public static String getIdFromSource(Object source) {
        Field[] fields;
        if (source == null) {
            return null;
        }
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JestId.class)) continue;
            try {
                field.setAccessible(true);
                Object name = field.get(source);
                return name == null ? null : name.toString();
            }
            catch (IllegalAccessException e) {
                log.error("Unhandled exception occurred while getting annotated id from source");
            }
        }
        return null;
    }

    public Collection<Object> getParameter(String parameter) {
        return this.parameterMap.get(parameter);
    }

    public Object getHeader(String header) {
        return this.headerMap.get(header);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headerMap;
    }

    @Override
    public String getURI() {
        String finalUri = this.URI;
        if (this.parameterMap.size() > 0) {
            try {
                finalUri = finalUri + this.buildQueryString();
            }
            catch (UnsupportedEncodingException e) {
                log.error("Error occurred while adding parameters to uri.", e);
            }
        }
        return finalUri;
    }

    protected void setURI(String URI2) {
        this.URI = URI2;
    }

    @Override
    public Object getData(Gson gson) {
        return null;
    }

    @Override
    public String getPathToResult() {
        return this.pathToResult;
    }

    protected void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }

    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        try {
            if (StringUtils.isNotBlank(this.indexName)) {
                sb.append(URLEncoder.encode(this.indexName, CHARSET));
                if (StringUtils.isNotBlank(this.typeName)) {
                    sb.append("/").append(URLEncoder.encode(this.typeName, CHARSET));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error("Error occurred while adding index/type to uri", e);
        }
        String uri = sb.toString();
        return uri;
    }

    protected String buildQueryString() throws UnsupportedEncodingException {
        StringBuilder queryString = new StringBuilder();
        Multiset<String> paramKeys = this.parameterMap.keys();
        queryString.append("?");
        for (String key : paramKeys) {
            Collection<Object> values = this.parameterMap.get(key);
            for (Object value : values) {
                queryString.append(URLEncoder.encode(key, CHARSET)).append("=").append(URLEncoder.encode(value.toString(), CHARSET)).append("&");
            }
        }
        queryString.deleteCharAt(queryString.length() - 1);
        return queryString.toString();
    }

    protected boolean isValid(String index, String type, String id) {
        return StringUtils.isNotBlank(index) && StringUtils.isNotBlank(type) && StringUtils.isNotBlank(id);
    }

    protected boolean isValid(Doc doc) {
        return this.isValid(doc.getIndex(), doc.getType(), doc.getId());
    }

    public boolean isBulkOperation() {
        return this.isBulkOperation;
    }

    protected void setBulkOperation(boolean bulkOperation) {
        this.isBulkOperation = bulkOperation;
    }

    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).append("uri", this.getURI()).append("method", this.getRestMethodName()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getURI()).append(this.getRestMethodName()).append(this.getHeaders()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractAction rhs = (AbstractAction)obj;
        return new EqualsBuilder().append(this.getURI(), rhs.getURI()).append(this.getRestMethodName(), rhs.getRestMethodName()).append(this.getHeaders(), rhs.getHeaders()).isEquals();
    }

    @Deprecated
    public final Boolean isOperationSucceed(Map result) {
        return this.isOperationSucceed(new JsonParser().parse(new Gson().toJson((Object)result, (Type)((Object)Map.class))).getAsJsonObject());
    }

    @Override
    public Boolean isOperationSucceed(JsonObject result) {
        return true;
    }

    @Override
    public abstract String getRestMethodName();

    protected static abstract class Builder<T extends Action, K> {
        protected Multimap<String, Object> parameters = HashMultimap.create();
        protected Map<String, Object> headers = new HashMap<String, Object>();

        protected Builder() {
        }

        public K setParameter(String key, Object value) {
            this.parameters.put(key, value);
            return (K)this;
        }

        @Deprecated
        public K setParameter(Map<String, Object> parameters) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                this.parameters.put(entry.getKey(), entry.getValue());
            }
            return (K)this;
        }

        public K setHeader(String key, Object value) {
            this.headers.put(key, value);
            return (K)this;
        }

        public K setHeader(Map<String, Object> headers) {
            this.headers.putAll(headers);
            return (K)this;
        }

        public K refresh(boolean refresh) {
            return this.setParameter("refresh", refresh);
        }

        public K resultCasing(String caseParam) {
            this.setParameter("case", caseParam);
            return (K)this;
        }

        public abstract T build();
    }
}

