/*
 * Decompiled with CFR 0.152.
 */
package com.searchly.jestdroid;

import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.StatusLine;
import ch.boye.httpclientandroidlib.client.HttpClient;
import ch.boye.httpclientandroidlib.client.methods.HttpEntityEnclosingRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpHead;
import ch.boye.httpclientandroidlib.client.methods.HttpPost;
import ch.boye.httpclientandroidlib.client.methods.HttpPut;
import ch.boye.httpclientandroidlib.client.methods.HttpRequestBase;
import ch.boye.httpclientandroidlib.client.methods.HttpUriRequest;
import ch.boye.httpclientandroidlib.entity.StringEntity;
import ch.boye.httpclientandroidlib.util.EntityUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.searchly.jestdroid.http.HttpDeleteWithEntity;
import com.searchly.jestdroid.http.HttpGetWithEntity;
import io.searchbox.Action;
import io.searchbox.client.AbstractJestClient;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestDroidClient
extends AbstractJestClient
implements JestClient {
    static final Logger log = LoggerFactory.getLogger(JestDroidClient.class);
    private HttpClient httpClient;
    private Charset entityEncoding = Charset.forName("utf-8");

    @Override
    public JestResult execute(Action clientRequest) throws IOException {
        String elasticSearchRestUrl = this.getRequestURL(this.getElasticSearchServer(), clientRequest.getURI());
        HttpUriRequest request = this.constructHttpMethod(clientRequest.getRestMethodName(), elasticSearchRestUrl, clientRequest.getData(this.gson));
        if (!clientRequest.getHeaders().isEmpty()) {
            for (Map.Entry<String, Object> header : clientRequest.getHeaders().entrySet()) {
                request.addHeader(header.getKey(), header.getValue().toString());
            }
        }
        HttpResponse response = this.httpClient.execute(request);
        if (request.getMethod().equalsIgnoreCase("HEAD") && response.getEntity() == null) {
            if (response.getStatusLine().getStatusCode() == 200) {
                response.setEntity(new StringEntity("{\"ok\" : true, \"found\" : true}"));
            } else if (response.getStatusLine().getStatusCode() == 404) {
                response.setEntity(new StringEntity("{\"ok\" : false, \"found\" : false}"));
            }
        }
        return this.deserializeResponse(response, clientRequest);
    }

    @Override
    public void executeAsync(Action clientRequest, JestResultHandler<JestResult> resultHandler) throws ExecutionException, InterruptedException, IOException {
        throw new UnsupportedOperationException("Jest-droid does not yet support async execution, sorry!");
    }

    @Override
    public void shutdownClient() {
        super.shutdownClient();
    }

    protected HttpUriRequest constructHttpMethod(String methodName, String url, Object data) throws UnsupportedEncodingException {
        HttpRequestBase httpUriRequest = null;
        if (methodName.equalsIgnoreCase("POST")) {
            httpUriRequest = new HttpPost(url);
            log.debug("POST method created based on client request");
        } else if (methodName.equalsIgnoreCase("PUT")) {
            httpUriRequest = new HttpPut(url);
            log.debug("PUT method created based on client request");
        } else if (methodName.equalsIgnoreCase("DELETE")) {
            httpUriRequest = new HttpDeleteWithEntity(url);
            log.debug("DELETE method created based on client request");
        } else if (methodName.equalsIgnoreCase("GET")) {
            httpUriRequest = new HttpGetWithEntity(url);
            log.debug("GET method created based on client request");
        } else if (methodName.equalsIgnoreCase("HEAD")) {
            httpUriRequest = new HttpHead(url);
            log.debug("HEAD method created based on client request");
        }
        if (httpUriRequest != null && httpUriRequest instanceof HttpEntityEnclosingRequestBase && data != null) {
            ((HttpEntityEnclosingRequestBase)httpUriRequest).setEntity(new StringEntity(this.createJsonStringEntity(data), this.entityEncoding));
        }
        return httpUriRequest;
    }

    private String createJsonStringEntity(Object data) {
        String entity = data instanceof String && this.isJson(data.toString()) ? data.toString() : this.gson.toJson(data);
        return entity;
    }

    private boolean isJson(String data) {
        try {
            JsonElement result = new JsonParser().parse(data);
            return !result.isJsonNull();
        }
        catch (JsonSyntaxException e) {
            String[] bulkRequest = data.split("\n");
            return bulkRequest.length >= 1;
        }
    }

    private JestResult deserializeResponse(HttpResponse response, Action clientRequest) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        return this.createNewElasticSearchResult(response.getEntity() != null ? EntityUtils.toString(response.getEntity()) : null, statusLine.getStatusCode(), statusLine.getReasonPhrase(), clientRequest);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Charset getEntityEncoding() {
        return this.entityEncoding;
    }

    public void setEntityEncoding(Charset entityEncoding) {
        this.entityEncoding = entityEncoding;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }
}

