/*
 * Decompiled with CFR 0.152.
 */
package io.saeid.fabloading;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.IntDef;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.melnykov.fab.FloatingActionButton;
import io.saeid.fabloading.model.Circle;
import io.saeid.materialfabloading.R;
import io.saeid.supportanimator.Animator;
import io.saeid.supportanimator.animator.SupportAnimator;
import io.saeid.supportanimator.listener.SupportAnimatorListener;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LoadingView
extends FloatingActionButton
implements SupportAnimatorListener {
    public static final int FROM_LEFT = 0;
    public static final int FROM_TOP = 1;
    public static final int FROM_RIGHT = 2;
    public static final int FROM_BOTTOM = 3;
    private static final boolean PRE_LOLLIPOP = Build.VERSION.SDK_INT < 21;
    private boolean mLoadingOnClick = false;
    private int mDuration = 0;
    private int mRepeats = 1;
    private SparseArray<LoadingItem> mItems = new SparseArray();
    private boolean mRunning = false;
    private boolean mPaused = false;
    private SupportAnimator mAnimator;
    private int mRepeatCounter = 1;
    private int mCurrentAnimationPos = 1;
    private LoadingItem mCurrentLoadingItem;
    private Circle mCircle = new Circle();
    private float mStep;
    private Path mPath = new Path();
    private Path mDrawablePath;
    private Paint mPaint = new Paint();
    private float mOffset = 0.0f;
    private Rect mBounds;
    private LoadingListener mListener;
    private Handler mHandler = new Handler();

    public LoadingView(Context context) {
        this(context, null);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        TypedArray attr = context.obtainStyledAttributes(attrs, R.styleable.LoadingView, 0, 0);
        if (attr != null) {
            try {
                this.mLoadingOnClick = attr.getBoolean(R.styleable.LoadingView_mfl_onclickLoading, false);
                this.mDuration = attr.getInt(R.styleable.LoadingView_mfl_duration, 400);
                this.mRepeatCounter = this.mRepeats = attr.getInt(R.styleable.LoadingView_mfl_repeat, 1);
            }
            finally {
                attr.recycle();
            }
        }
        this.mPaint.setAntiAlias(true);
        if (this.mLoadingOnClick) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LoadingView.this.startAnimation();
                }
            });
        }
    }

    public LoadingView addAnimation(int color, int drawable, int type) {
        if (!this.mRunning) {
            if (this.mItems.size() == 0) {
                if (drawable != 0) {
                    this.setImageDrawable(this.getResources().getDrawable(drawable));
                }
                this.setColorNormal(color);
                this.setColorPressed(color);
                this.setColorRipple(0);
            }
            this.mItems.put(this.mItems.size(), (Object)new LoadingItem(color, drawable, type));
        }
        return this;
    }

    public LoadingView removeAnimation(int position) {
        if (!this.mRunning) {
            this.mItems.remove(position);
        }
        return this;
    }

    public void startAnimation() {
        if (!this.mRunning && this.mItems.size() > 1 && !this.mPaused) {
            this.mAnimator = Animator.with((SupportAnimatorListener)this, (int)this.mDuration);
            this.mAnimator.start();
        }
    }

    public void resumeAnimation() {
        this.mPaused = false;
    }

    public void pauseAnimation() {
        this.mPaused = true;
    }

    public void addListener(LoadingListener listener) {
        this.mListener = listener;
    }

    @Deprecated
    public void onSupportAnimationAttach() {
    }

    public void onSupportAnimationStart() {
        this.mRunning = true;
        this.mCurrentLoadingItem = (LoadingItem)this.mItems.get(this.mCurrentAnimationPos);
        this.mCircle.restore();
        this.obtainCircle();
        this.mStep = this.mCircle.radius * 2.0f / ((float)this.mDuration / 1000.0f);
        if (this.mCurrentLoadingItem.drawableRes != 0) {
            this.mBounds = new Rect(0, 0, this.getWidth(), this.getHeight());
            if (this.mCurrentLoadingItem.drawable == null) {
                this.mCurrentLoadingItem.drawable = this.getResources().getDrawable(this.mCurrentLoadingItem.drawableRes);
            }
            if (this.mCurrentLoadingItem.drawable != null) {
                this.mCurrentLoadingItem.drawable.setBounds(this.mBounds);
            }
        }
        if (this.mListener != null) {
            this.mListener.onAnimationStart(this.mCurrentAnimationPos);
        }
    }

    private void obtainCircle() {
        this.mOffset = 0.0f;
        if (PRE_LOLLIPOP) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
            this.mOffset = (float)Math.abs(params.leftMargin + params.rightMargin) * 0.5f;
        }
        float halfWidth = (float)this.getWidth() * 0.5f;
        float halfHeight = (float)this.getHeight() * 0.5f;
        switch (this.mCurrentLoadingItem.type) {
            case 0: {
                this.mCircle.x = -halfWidth + this.mOffset;
                this.mCircle.y = halfHeight;
                break;
            }
            case 1: {
                this.mCircle.x = halfWidth;
                this.mCircle.y = -halfHeight + this.mOffset;
                break;
            }
            case 2: {
                this.mCircle.x = halfWidth + (float)this.getWidth() - this.mOffset;
                this.mCircle.y = halfHeight;
                break;
            }
            case 3: {
                this.mCircle.x = halfWidth;
                this.mCircle.y = halfHeight + (float)this.getHeight() - this.mOffset;
            }
        }
        this.mCircle.radius = Math.max(halfWidth, halfHeight) - this.mOffset + 8.0f;
        this.mPath.addCircle((float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f, this.mCircle.radius - 7.0f, Path.Direction.CW);
        this.mPaint.setColor(this.mCurrentLoadingItem.color);
    }

    public void onSupportAnimationEnd() {
        this.mRunning = false;
        this.mCurrentAnimationPos = (this.mCurrentAnimationPos + 1) % this.mItems.size();
        this.setColorNormal(this.mCurrentLoadingItem.color);
        this.setColorPressed(this.mCurrentLoadingItem.color);
        if (this.mCurrentLoadingItem.drawable != null) {
            this.setImageDrawable(this.mCurrentLoadingItem.drawable);
        }
        if (this.mRepeatCounter > 1) {
            --this.mRepeatCounter;
            if (this.mListener != null) {
                this.mListener.onAnimationRepeat(this.mCurrentAnimationPos);
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    LoadingView.this.startAnimation();
                }
            }, 50L);
        } else if (this.mRepeatCounter == 1 && this.mRepeats > 1) {
            this.mRepeatCounter = this.mRepeats;
            if (this.mListener != null) {
                this.mListener.onAnimationRepeat(this.mCurrentAnimationPos);
            }
        } else if (this.mListener != null) {
            this.mListener.onAnimationEnd(this.mCurrentAnimationPos);
        }
    }

    public void onSupportAnimationCancel() {
        this.onSupportAnimationEnd();
    }

    public void onSupportAnimationUpdate() {
        this.moveCircle();
        this.attachDrawablePath();
        this.invalidate();
    }

    private void moveCircle() {
        float step = this.mStep * 0.01666f;
        switch (this.mCurrentLoadingItem.type) {
            case 0: {
                if (!(this.mCircle.x < (float)this.getWidth() * 0.5f)) break;
                this.mCircle.x += step;
                break;
            }
            case 1: {
                if (!(this.mCircle.y < (float)this.getHeight() * 0.5f)) break;
                this.mCircle.y += step;
                break;
            }
            case 2: {
                if (!(this.mCircle.x > (float)this.getWidth() * 0.5f)) break;
                this.mCircle.x -= step;
                break;
            }
            case 3: {
                if (!(this.mCircle.y > (float)this.getHeight() * 0.5f)) break;
                this.mCircle.y -= step;
            }
        }
    }

    private void attachDrawablePath() {
        if (this.mCurrentLoadingItem.drawableRes != 0) {
            this.mDrawablePath = new Path();
            this.mDrawablePath.addCircle(this.mCircle.x, this.mCircle.y, this.mCircle.radius, Path.Direction.CW);
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mRunning) {
            canvas.clipPath(this.mPath);
            int count = canvas.getSaveCount();
            canvas.drawCircle(this.mCircle.x, this.mCircle.y, this.mCircle.radius, this.mPaint);
            canvas.save();
            if (this.mCurrentLoadingItem.drawable != null) {
                canvas.clipPath(this.mDrawablePath);
                this.mCurrentLoadingItem.drawable.draw(canvas);
            }
            canvas.restoreToCount(count);
        }
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
        this.mAnimator = Animator.with((SupportAnimatorListener)this, (int)duration);
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setRepeat(int repeat) {
        this.mRepeatCounter = repeat;
        this.mRepeats = repeat;
    }

    public int getRepeat() {
        return this.mRepeats;
    }

    public static class LoadingItem {
        public int color;
        public int drawableRes;
        public Drawable drawable = null;
        public int type;

        public LoadingItem(int color, int drawableRes, int type) {
            this.color = color;
            this.drawableRes = drawableRes;
            this.type = type;
        }
    }

    public static interface LoadingListener {
        public void onAnimationStart(int var1);

        public void onAnimationRepeat(int var1);

        public void onAnimationEnd(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L, 3L})
    public static @interface AnimationMode {
    }
}

