/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.frame.FrameLengthFlyweight;
import io.rsocket.internal.BaseDuplexConnection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public final class TcpDuplexConnection
extends BaseDuplexConnection {
    private final Connection connection;
    private final ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
    private final boolean encodeLength;

    public TcpDuplexConnection(Connection connection) {
        this(connection, true);
    }

    public TcpDuplexConnection(Connection connection, boolean encodeLength) {
        this.encodeLength = encodeLength;
        this.connection = Objects.requireNonNull(connection, "connection must not be null");
        connection.channel().closeFuture().addListener(future -> {
            if (!this.isDisposed()) {
                this.dispose();
            }
        });
    }

    protected void doOnClose() {
        if (!this.connection.isDisposed()) {
            this.connection.dispose();
        }
    }

    public Flux<ByteBuf> receive() {
        return this.connection.inbound().receive().map(this::decode);
    }

    public Mono<Void> send(Publisher<ByteBuf> frames) {
        if (frames instanceof Mono) {
            return this.connection.outbound().sendObject((Publisher)((Mono)frames).map(this::encode)).then();
        }
        return this.connection.outbound().send((Publisher)Flux.from(frames).map(this::encode)).then();
    }

    private ByteBuf encode(ByteBuf frame) {
        if (this.encodeLength) {
            return FrameLengthFlyweight.encode((ByteBufAllocator)this.allocator, (int)frame.readableBytes(), (ByteBuf)frame);
        }
        return frame;
    }

    private ByteBuf decode(ByteBuf frame) {
        if (this.encodeLength) {
            return FrameLengthFlyweight.frame((ByteBuf)frame).retain();
        }
        return frame;
    }
}

