/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpMethod;
import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import io.rsocket.transport.netty.server.CloseableChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public final class WebsocketRouteTransport
implements ServerTransport<Closeable> {
    private final UriPathTemplate template;
    private final Consumer<? super HttpServerRoutes> routesBuilder;
    private final HttpServer server;

    public WebsocketRouteTransport(HttpServer server, Consumer<? super HttpServerRoutes> routesBuilder, String path) {
        this.server = Objects.requireNonNull(server, "server must not be null");
        this.routesBuilder = Objects.requireNonNull(routesBuilder, "routesBuilder must not be null");
        this.template = new UriPathTemplate(Objects.requireNonNull(path, "path must not be null"));
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.route(routes -> {
            this.routesBuilder.accept((HttpServerRoutes)routes);
            routes.ws(hsr -> hsr.method().equals((Object)HttpMethod.GET) && this.template.matches(hsr.uri()), WebsocketRouteTransport.newHandler(acceptor, mtu), null, 0xFFFFFF);
        }).bind().map(CloseableChannel::new);
    }

    public static BiFunction<WebsocketInbound, WebsocketOutbound, Publisher<Void>> newHandler(ServerTransport.ConnectionAcceptor acceptor) {
        return WebsocketRouteTransport.newHandler(acceptor, 0);
    }

    public static BiFunction<WebsocketInbound, WebsocketOutbound, Publisher<Void>> newHandler(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        return (in, out) -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((Connection)in);
            if (mtu > 0) {
                connection = new FragmentationDuplexConnection((DuplexConnection)connection, ByteBufAllocator.DEFAULT, mtu, false, "server");
            }
            return acceptor.apply((DuplexConnection)connection).then(out.neverComplete());
        };
    }

    static final class UriPathTemplate {
        private static final Pattern FULL_SPLAT_PATTERN = Pattern.compile("[\\*][\\*]");
        private static final String FULL_SPLAT_REPLACEMENT = ".*";
        private static final Pattern NAME_SPLAT_PATTERN = Pattern.compile("\\{([^/]+?)\\}[\\*][\\*]");
        private static final String NAME_SPLAT_REPLACEMENT = "(?<%NAME%>.*)";
        private static final Pattern NAME_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
        private static final String NAME_REPLACEMENT = "(?<%NAME%>[^\\/]*)";
        private final List<String> pathVariables = new ArrayList<String>();
        private final HashMap<String, Matcher> matchers = new HashMap();
        private final HashMap<String, Map<String, String>> vars = new HashMap();
        private final Pattern uriPattern;

        static String filterQueryParams(String uri) {
            int hasQuery = uri.lastIndexOf("?");
            if (hasQuery != -1) {
                return uri.substring(0, hasQuery);
            }
            return uri;
        }

        UriPathTemplate(String uriPattern) {
            String name;
            int i;
            String s = "^" + UriPathTemplate.filterQueryParams(uriPattern);
            Matcher m = NAME_SPLAT_PATTERN.matcher(s);
            while (m.find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    name = m.group(i);
                    this.pathVariables.add(name);
                    s = m.replaceFirst(NAME_SPLAT_REPLACEMENT.replaceAll("%NAME%", name));
                    m.reset(s);
                }
            }
            m = NAME_PATTERN.matcher(s);
            while (m.find()) {
                for (i = 1; i <= m.groupCount(); ++i) {
                    name = m.group(i);
                    this.pathVariables.add(name);
                    s = m.replaceFirst(NAME_REPLACEMENT.replaceAll("%NAME%", name));
                    m.reset(s);
                }
            }
            m = FULL_SPLAT_PATTERN.matcher(s);
            while (m.find()) {
                s = m.replaceAll(FULL_SPLAT_REPLACEMENT);
                m.reset(s);
            }
            this.uriPattern = Pattern.compile(s + "$");
        }

        public boolean matches(String uri) {
            return this.matcher(uri).matches();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final Map<String, String> match(String uri) {
            Map<String, String> pathParameters = this.vars.get(uri);
            if (null != pathParameters) {
                return pathParameters;
            }
            pathParameters = new HashMap<String, String>();
            Matcher m = this.matcher(uri);
            if (m.matches()) {
                int i = 1;
                for (String name : this.pathVariables) {
                    String val = m.group(i++);
                    pathParameters.put(name, val);
                }
            }
            HashMap<String, Map<String, String>> hashMap = this.vars;
            synchronized (hashMap) {
                this.vars.put(uri, pathParameters);
            }
            return pathParameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Matcher matcher(String uri) {
            Matcher m = this.matchers.get(uri = UriPathTemplate.filterQueryParams(uri));
            if (null == m) {
                m = this.uriPattern.matcher(uri);
                HashMap<String, Matcher> hashMap = this.matchers;
                synchronized (hashMap) {
                    this.matchers.put(uri, m);
                }
            }
            return m;
        }
    }
}

