/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import io.rsocket.transport.netty.server.CloseableChannel;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRoutes;

public final class WebsocketRouteTransport
implements ServerTransport<Closeable> {
    private final String path;
    private final Consumer<? super HttpServerRoutes> routesBuilder;
    private final HttpServer server;

    public WebsocketRouteTransport(HttpServer server, Consumer<? super HttpServerRoutes> routesBuilder, String path) {
        this.server = Objects.requireNonNull(server, "server must not be null");
        this.routesBuilder = Objects.requireNonNull(routesBuilder, "routesBuilder must not be null");
        this.path = Objects.requireNonNull(path, "path must not be null");
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.route(routes -> {
            this.routesBuilder.accept((HttpServerRoutes)routes);
            routes.ws(this.path, (in, out) -> {
                WebsocketDuplexConnection connection = new WebsocketDuplexConnection((Connection)in);
                if (mtu > 0) {
                    connection = new FragmentationDuplexConnection((DuplexConnection)connection, ByteBufAllocator.DEFAULT, mtu, false);
                }
                return acceptor.apply((DuplexConnection)connection).then(out.neverComplete());
            });
        }).bind().map(CloseableChannel::new);
    }
}

