/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.netty.channel.ChannelHandler;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.RSocketLengthCodec;
import io.rsocket.transport.netty.TcpDuplexConnection;
import io.rsocket.transport.netty.server.NettyContextCloseable;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.tcp.TcpServer;

public final class TcpServerTransport
implements ServerTransport<NettyContextCloseable> {
    private final TcpServer server;

    private TcpServerTransport(TcpServer server) {
        this.server = server;
    }

    public static TcpServerTransport create(int port) {
        TcpServer server = TcpServer.create((int)port);
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        TcpServer server = TcpServer.create((String)bindAddress, (int)port);
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        TcpServer server = TcpServer.create((String)address.getHostName(), (int)address.getPort());
        return TcpServerTransport.create(server);
    }

    public static TcpServerTransport create(TcpServer server) {
        Objects.requireNonNull(server, "server must not be null");
        return new TcpServerTransport(server);
    }

    public Mono<NettyContextCloseable> start(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.newHandler((in, out) -> {
            in.context().addHandler((ChannelHandler)new RSocketLengthCodec());
            TcpDuplexConnection connection = new TcpDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            acceptor.apply((DuplexConnection)connection).subscribe();
            return out.neverComplete();
        }).map(NettyContextCloseable::new);
    }
}

