/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.client;

import io.netty.channel.ChannelHandler;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.RSocketLengthCodec;
import io.rsocket.transport.netty.TcpDuplexConnection;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;
import reactor.ipc.netty.tcp.TcpClient;

public final class TcpClientTransport
implements ClientTransport {
    private final TcpClient client;

    private TcpClientTransport(TcpClient client) {
        this.client = client;
    }

    public static TcpClientTransport create(int port) {
        TcpClient tcpClient = TcpClient.create((int)port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(String bindAddress, int port) {
        Objects.requireNonNull(bindAddress, "bindAddress must not be null");
        TcpClient tcpClient = TcpClient.create((String)bindAddress, (int)port);
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(InetSocketAddress address) {
        Objects.requireNonNull(address, "address must not be null");
        TcpClient tcpClient = TcpClient.create((String)address.getHostString(), (int)address.getPort());
        return TcpClientTransport.create(tcpClient);
    }

    public static TcpClientTransport create(TcpClient client) {
        Objects.requireNonNull(client, "client must not be null");
        return new TcpClientTransport(client);
    }

    public Mono<DuplexConnection> connect() {
        return Mono.create((T sink) -> this.client.newHandler((in, out) -> {
            in.context().addHandler((ChannelHandler)new RSocketLengthCodec());
            TcpDuplexConnection connection = new TcpDuplexConnection((NettyInbound)in, (NettyOutbound)out, in.context());
            sink.success((Object)connection);
            return connection.onClose();
        }).doOnError(arg_0 -> ((MonoSink)sink).error(arg_0)).subscribe());
    }
}

