/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty;

import io.netty.buffer.ByteBuf;
import io.rsocket.DuplexConnection;
import io.rsocket.Frame;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyContext;
import reactor.ipc.netty.NettyInbound;
import reactor.ipc.netty.NettyOutbound;

public class NettyDuplexConnection
implements DuplexConnection {
    private final NettyInbound in;
    private final NettyOutbound out;
    private final NettyContext context;

    public NettyDuplexConnection(NettyInbound in, NettyOutbound out, NettyContext context) {
        this.in = in;
        this.out = out;
        this.context = context;
    }

    public Mono<Void> send(Publisher<Frame> frames) {
        return Flux.from(frames).concatMap(this::sendOne).then();
    }

    public Mono<Void> sendOne(Frame frame) {
        return this.out.sendObject((Object)frame.content()).then();
    }

    public Flux<Frame> receive() {
        return this.in.receive().map(buf -> Frame.from((ByteBuf)buf.retain()));
    }

    public void dispose() {
        this.context.dispose();
    }

    public boolean isDisposed() {
        return this.context.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.context.onClose();
    }
}

