/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.local.LocalClientTransport;
import io.rsocket.transport.local.LocalSocketAddress;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import reactor.core.Disposable;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.Nullable;

public final class LocalServerTransport
implements ServerTransport<Closeable> {
    private static final ConcurrentMap<String, ServerCloseableAcceptor> registry = new ConcurrentHashMap<String, ServerCloseableAcceptor>();
    private final String name;

    private LocalServerTransport(String name) {
        this.name = name;
    }

    public static LocalServerTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return new LocalServerTransport(name);
    }

    public static LocalServerTransport createEphemeral() {
        return LocalServerTransport.create(UUID.randomUUID().toString());
    }

    public static void dispose(String name) {
        Objects.requireNonNull(name, "name must not be null");
        ServerCloseableAcceptor sca = (ServerCloseableAcceptor)registry.remove(name);
        if (sca != null) {
            sca.dispose();
        }
    }

    @Nullable
    static ServerTransport.ConnectionAcceptor findServer(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return (ServerTransport.ConnectionAcceptor)registry.get(name);
    }

    String getName() {
        return this.name;
    }

    public LocalClientTransport clientTransport() {
        return LocalClientTransport.create(this.name);
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return Mono.create((T sink) -> {
            ServerCloseableAcceptor closeable = new ServerCloseableAcceptor(this.name, acceptor);
            if (registry.putIfAbsent(this.name, closeable) != null) {
                sink.error((Throwable)new IllegalStateException("name already registered: " + this.name));
            }
            sink.success((Object)closeable);
        });
    }

    static class ServerCloseableAcceptor
    implements ServerTransport.ConnectionAcceptor,
    Closeable {
        private final LocalSocketAddress address;
        private final ServerTransport.ConnectionAcceptor acceptor;
        private final Set<DuplexConnection> activeConnections = ConcurrentHashMap.newKeySet();
        private final Sinks.Empty<Void> onClose = Sinks.unsafe().empty();

        ServerCloseableAcceptor(String name, ServerTransport.ConnectionAcceptor acceptor) {
            Objects.requireNonNull(name, "name must not be null");
            this.address = new LocalSocketAddress(name);
            this.acceptor = acceptor;
        }

        public Mono<Void> apply(DuplexConnection duplexConnection) {
            this.activeConnections.add(duplexConnection);
            duplexConnection.onClose().doFinally(__ -> this.activeConnections.remove(duplexConnection)).subscribe();
            return this.acceptor.apply(duplexConnection);
        }

        public void dispose() {
            if (!registry.remove(this.address.getName(), this)) {
                return;
            }
            Mono.whenDelayError((Iterable)this.activeConnections.stream().peek(Disposable::dispose).map(Closeable::onClose).collect(Collectors.toList())).subscribe(null, arg_0 -> this.onClose.tryEmitError(arg_0), () -> this.onClose.tryEmitEmpty());
        }

        public boolean isDisposed() {
            return (Boolean)this.onClose.scan(Scannable.Attr.TERMINATED) != false || (Boolean)this.onClose.scan(Scannable.Attr.CANCELLED) != false;
        }

        public Mono<Void> onClose() {
            return this.onClose.asMono();
        }
    }
}

