/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.rsocket.Closeable;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.local.LocalClientTransport;
import io.rsocket.transport.local.LocalSocketAddress;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.util.annotation.Nullable;

public final class LocalServerTransport
implements ServerTransport<Closeable> {
    private static final ConcurrentMap<String, ServerTransport.ConnectionAcceptor> registry = new ConcurrentHashMap<String, ServerTransport.ConnectionAcceptor>();
    private final String name;

    private LocalServerTransport(String name) {
        this.name = name;
    }

    public static LocalServerTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return new LocalServerTransport(name);
    }

    public static LocalServerTransport createEphemeral() {
        return LocalServerTransport.create(UUID.randomUUID().toString());
    }

    public static void dispose(String name) {
        Objects.requireNonNull(name, "name must not be null");
        registry.remove(name);
    }

    @Nullable
    static ServerTransport.ConnectionAcceptor findServer(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return (ServerTransport.ConnectionAcceptor)registry.get(name);
    }

    String getName() {
        return this.name;
    }

    public LocalClientTransport clientTransport() {
        return LocalClientTransport.create(this.name);
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return Mono.create((T sink) -> {
            ServerCloseable closeable = new ServerCloseable(this.name, acceptor);
            if (registry.putIfAbsent(this.name, acceptor) != null) {
                throw new IllegalStateException("name already registered: " + this.name);
            }
            sink.success((Object)closeable);
        });
    }

    static class ServerCloseable
    implements Closeable {
        private final LocalSocketAddress address;
        private final ServerTransport.ConnectionAcceptor acceptor;
        private final MonoProcessor<Void> onClose = MonoProcessor.create();

        ServerCloseable(String name, ServerTransport.ConnectionAcceptor acceptor) {
            Objects.requireNonNull(name, "name must not be null");
            this.address = new LocalSocketAddress(name);
            this.acceptor = acceptor;
        }

        public void dispose() {
            if (!registry.remove(this.address.getName(), this.acceptor)) {
                throw new AssertionError();
            }
            this.onClose.onComplete();
        }

        public boolean isDisposed() {
            return this.onClose.isDisposed();
        }

        public Mono<Void> onClose() {
            return this.onClose;
        }
    }
}

