/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.local.LocalDuplexConnection;
import io.rsocket.transport.local.LocalServerTransport;
import java.util.Objects;
import java.util.Queue;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.UnicastProcessor;
import reactor.util.concurrent.Queues;

public final class LocalClientTransport
implements ClientTransport {
    private final String name;

    private LocalClientTransport(String name) {
        this.name = name;
    }

    public static LocalClientTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return new LocalClientTransport(name);
    }

    private Mono<DuplexConnection> connect() {
        return Mono.defer(() -> {
            LocalServerTransport.ServerDuplexConnectionAcceptor server = LocalServerTransport.findServer(this.name);
            if (server == null) {
                return Mono.error((Throwable)new IllegalArgumentException("Could not find server: " + this.name));
            }
            UnicastProcessor in = UnicastProcessor.create((Queue)((Queue)Queues.unboundedMultiproducer().get()));
            UnicastProcessor out = UnicastProcessor.create((Queue)((Queue)Queues.unboundedMultiproducer().get()));
            MonoProcessor closeNotifier = MonoProcessor.create();
            server.accept(new LocalDuplexConnection((Flux<ByteBuf>)out, (Subscriber<ByteBuf>)in, (MonoProcessor<Void>)closeNotifier));
            return Mono.just((Object)new LocalDuplexConnection((Flux<ByteBuf>)in, (Subscriber<ByteBuf>)out, (MonoProcessor<Void>)closeNotifier));
        });
    }

    public Mono<DuplexConnection> connect(int mtu) {
        Mono<DuplexConnection> connect = this.connect();
        if (mtu > 0) {
            return connect.map(duplexConnection -> new FragmentationDuplexConnection(duplexConnection, ByteBufAllocator.DEFAULT, mtu, false, "client"));
        }
        return connect;
    }
}

