/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.netty.buffer.ByteBufAllocator;
import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.local.LocalClientTransport;
import io.rsocket.transport.local.LocalSocketAddress;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.util.annotation.Nullable;

public final class LocalServerTransport
implements ServerTransport<Closeable> {
    private static final ConcurrentMap<String, ServerDuplexConnectionAcceptor> registry = new ConcurrentHashMap<String, ServerDuplexConnectionAcceptor>();
    private final String name;

    private LocalServerTransport(String name) {
        this.name = name;
    }

    public static LocalServerTransport create(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return new LocalServerTransport(name);
    }

    public static LocalServerTransport createEphemeral() {
        return LocalServerTransport.create(UUID.randomUUID().toString());
    }

    public static void dispose(String name) {
        Objects.requireNonNull(name, "name must not be null");
        registry.remove(name);
    }

    @Nullable
    static ServerDuplexConnectionAcceptor findServer(String name) {
        Objects.requireNonNull(name, "name must not be null");
        return (ServerDuplexConnectionAcceptor)registry.get(name);
    }

    public LocalClientTransport clientTransport() {
        return LocalClientTransport.create(this.name);
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return Mono.create((T sink) -> {
            ServerDuplexConnectionAcceptor serverDuplexConnectionAcceptor = new ServerDuplexConnectionAcceptor(this.name, acceptor, mtu);
            if (registry.putIfAbsent(this.name, serverDuplexConnectionAcceptor) != null) {
                throw new IllegalStateException("name already registered: " + this.name);
            }
            sink.success((Object)serverDuplexConnectionAcceptor);
        });
    }

    String getName() {
        return this.name;
    }

    static class ServerDuplexConnectionAcceptor
    implements Consumer<DuplexConnection>,
    Closeable {
        private final ServerTransport.ConnectionAcceptor acceptor;
        private final LocalSocketAddress address;
        private final MonoProcessor<Void> onClose = MonoProcessor.create();
        private final int mtu;

        ServerDuplexConnectionAcceptor(String name, ServerTransport.ConnectionAcceptor acceptor, int mtu) {
            Objects.requireNonNull(name, "name must not be null");
            this.address = new LocalSocketAddress(name);
            this.acceptor = Objects.requireNonNull(acceptor, "acceptor must not be null");
            this.mtu = mtu;
        }

        @Override
        public void accept(DuplexConnection duplexConnection) {
            Objects.requireNonNull(duplexConnection, "duplexConnection must not be null");
            if (this.mtu > 0) {
                duplexConnection = new FragmentationDuplexConnection(duplexConnection, ByteBufAllocator.DEFAULT, this.mtu, false);
            }
            this.acceptor.apply(duplexConnection).subscribe();
        }

        public void dispose() {
            if (!registry.remove(this.address.getName(), this)) {
                throw new AssertionError();
            }
            this.onClose.onComplete();
        }

        public boolean isDisposed() {
            return this.onClose.isDisposed();
        }

        public Mono<Void> onClose() {
            return this.onClose;
        }
    }
}

