/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Payload;
import io.rsocket.test.ClientSetupRule;
import io.rsocket.test.CountdownBaseSubscriber;
import io.rsocket.util.DefaultPayload;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

public abstract class BaseClientServerTest<T extends ClientSetupRule<?, ?>> {
    public final T setup = this.createClientServer();

    protected abstract T createClientServer();

    @BeforeEach
    public void init() {
        ((ClientSetupRule)this.setup).init();
    }

    @AfterEach
    public void teardown() {
        ((ClientSetupRule)this.setup).tearDown();
    }

    @Test
    @Timeout(value=10000L)
    public void testFireNForget10() {
        long outputCount = (Long)Flux.range((int)1, (int)10).flatMap(i -> ((ClientSetupRule)this.setup).getRSocket().fireAndForget(this.testPayload((int)i))).doOnError(Throwable::printStackTrace).count().block();
        Assertions.assertThat((long)outputCount).isZero();
    }

    @Test
    @Timeout(value=10000L)
    public void testPushMetadata10() {
        long outputCount = (Long)Flux.range((int)1, (int)10).flatMap(i -> ((ClientSetupRule)this.setup).getRSocket().metadataPush(DefaultPayload.create((CharSequence)"", (CharSequence)"metadata"))).doOnError(Throwable::printStackTrace).count().block();
        Assertions.assertThat((long)outputCount).isZero();
    }

    @Test
    public void testRequestResponse1() {
        long outputCount = (Long)Flux.range((int)1, (int)1).flatMap(i -> ((ClientSetupRule)this.setup).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assertions.assertThat((long)outputCount).isZero();
    }

    @Test
    @Timeout(value=10000L)
    public void testRequestResponse10() {
        long outputCount = (Long)Flux.range((int)1, (int)10).flatMap(i -> ((ClientSetupRule)this.setup).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assertions.assertThat((long)outputCount).isEqualTo(10L);
    }

    private Payload testPayload(int metadataPresent) {
        String metadata;
        switch (metadataPresent % 5) {
            case 0: {
                metadata = null;
                break;
            }
            case 1: {
                metadata = "";
                break;
            }
            default: {
                metadata = "metadata";
            }
        }
        return DefaultPayload.create((CharSequence)"hello", (CharSequence)metadata);
    }

    @Test
    @Timeout(value=10000L)
    public void testRequestResponse100() {
        long outputCount = (Long)Flux.range((int)1, (int)100).flatMap(i -> ((ClientSetupRule)this.setup).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assertions.assertThat((long)outputCount).isEqualTo(100L);
    }

    @Test
    @Timeout(value=20000L)
    public void testRequestResponse10_000() {
        long outputCount = (Long)Flux.range((int)1, (int)10000).flatMap(i -> ((ClientSetupRule)this.setup).getRSocket().requestResponse(this.testPayload((int)i)).map(Payload::getDataUtf8)).doOnError(Throwable::printStackTrace).count().block();
        Assertions.assertThat((long)outputCount).isEqualTo(10000L);
    }

    @Test
    @Timeout(value=10000L)
    public void testRequestStream() {
        Flux publisher = ((ClientSetupRule)this.setup).getRSocket().requestStream(this.testPayload(3));
        long count = (Long)publisher.take(5L).count().block();
        Assertions.assertThat((long)count).isEqualTo(5L);
    }

    @Test
    @Timeout(value=10000L)
    public void testRequestStreamAll() {
        Flux publisher = ((ClientSetupRule)this.setup).getRSocket().requestStream(this.testPayload(3));
        long count = (Long)publisher.count().block();
        Assertions.assertThat((long)count).isEqualTo(10000L);
    }

    @Test
    @Timeout(value=10000L)
    public void testRequestStreamWithRequestN() {
        CountdownBaseSubscriber ts = new CountdownBaseSubscriber();
        ts.expect(5);
        ((ClientSetupRule)this.setup).getRSocket().requestStream(this.testPayload(3)).subscribe((CoreSubscriber)ts);
        ts.await();
        Assertions.assertThat((int)ts.count()).isEqualTo(5);
        ts.expect(5);
        ts.await();
        ts.cancel();
        Assertions.assertThat((int)ts.count()).isEqualTo(10);
    }

    @Test
    @Timeout(value=10000L)
    public void testRequestStreamWithDelayedRequestN() {
        CountdownBaseSubscriber ts = new CountdownBaseSubscriber();
        ((ClientSetupRule)this.setup).getRSocket().requestStream(this.testPayload(3)).subscribe((CoreSubscriber)ts);
        ts.expect(5);
        ts.await();
        Assertions.assertThat((int)ts.count()).isEqualTo(5);
        ts.expect(5);
        ts.await();
        ts.cancel();
        Assertions.assertThat((int)ts.count()).isEqualTo(10);
    }

    @Test
    @Timeout(value=10000L)
    public void testChannel0() {
        Flux publisher = ((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)Flux.empty());
        long count = (Long)publisher.count().block();
        Assertions.assertThat((long)count).isZero();
    }

    @Test
    @Timeout(value=10000L)
    public void testChannel1() {
        Flux publisher = ((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)Flux.just((Object)this.testPayload(0)));
        long count = (Long)publisher.count().block();
        Assertions.assertThat((long)count).isOne();
    }

    @Test
    @Timeout(value=10000L)
    public void testChannel3() {
        Flux publisher = ((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)Flux.just((Object[])new Payload[]{this.testPayload(0), this.testPayload(1), this.testPayload(2)}));
        long count = (Long)publisher.count().block();
        Assertions.assertThat((long)count).isEqualTo(3L);
    }

    @Test
    @Timeout(value=10000L)
    public void testChannel512() {
        Flux payloads = Flux.range((int)1, (int)512).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assertions.assertThat((long)count).isEqualTo(512L);
    }

    @Test
    @Timeout(value=30000L)
    public void testChannel20_000() {
        Flux payloads = Flux.range((int)1, (int)20000).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assertions.assertThat((long)count).isEqualTo(20000L);
    }

    @Test
    @Timeout(value=60000L)
    public void testChannel200_000() {
        Flux payloads = Flux.range((int)1, (int)200000).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assertions.assertThat((long)count).isEqualTo(200000L);
    }

    @Test
    @Timeout(value=60000L)
    @Disabled
    public void testChannel2_000_000() {
        AtomicInteger counter = new AtomicInteger(0);
        Flux payloads = Flux.range((int)1, (int)2000000).map(i -> DefaultPayload.create((CharSequence)("hello " + i)));
        long count = (Long)((ClientSetupRule)this.setup).getRSocket().requestChannel((Publisher)payloads).count().block();
        Assertions.assertThat((long)count).isEqualTo(2000000L);
    }
}

