/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Closeable;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.core.RSocketServer;
import io.rsocket.test.TestRSocket;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import reactor.core.publisher.Mono;

public class ClientSetupRule<T, S extends Closeable>
extends ExternalResource {
    private static final String data = "hello world";
    private static final String metadata = "metadata";
    private Supplier<T> addressSupplier;
    private BiFunction<T, S, RSocket> clientConnector;
    private Function<T, S> serverInit;
    private RSocket client;

    public ClientSetupRule(Supplier<T> addressSupplier, BiFunction<T, S, ClientTransport> clientTransportSupplier, Function<T, ServerTransport<S>> serverTransportSupplier) {
        this.addressSupplier = addressSupplier;
        this.serverInit = address -> (Closeable)RSocketServer.create((setup, rsocket) -> Mono.just((Object)new TestRSocket(data, metadata))).bind((ServerTransport)serverTransportSupplier.apply(address)).block();
        this.clientConnector = (address, server) -> (RSocket)RSocketConnector.connectWith((ClientTransport)((ClientTransport)clientTransportSupplier.apply(address, server))).doOnError(Throwable::printStackTrace).block();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Object address = ClientSetupRule.this.addressSupplier.get();
                Closeable server = (Closeable)ClientSetupRule.this.serverInit.apply(address);
                ClientSetupRule.this.client = (RSocket)ClientSetupRule.this.clientConnector.apply(address, server);
                base.evaluate();
                server.dispose();
            }
        };
    }

    public RSocket getRSocket() {
        return this.client;
    }

    public String expectedPayloadData() {
        return data;
    }

    public String expectedPayloadMetadata() {
        return metadata;
    }
}

