/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.netty.util.ReferenceCounted;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.util.ByteBufPayload;
import java.time.Duration;
import org.HdrHistogram.Recorder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PingClient {
    private final Payload payload;
    private final Mono<RSocket> client;

    public PingClient(Mono<RSocket> client) {
        this.client = client;
        this.payload = ByteBufPayload.create((String)"hello");
    }

    public Recorder startTracker(Duration interval) {
        Recorder histogram = new Recorder(3600000000000L, 3);
        Flux.interval((Duration)interval).doOnNext(aLong -> {
            System.out.println("---- PING/ PONG HISTO ----");
            histogram.getIntervalHistogram().outputPercentileDistribution(System.out, 5, Double.valueOf(1000.0), false);
            System.out.println("---- PING/ PONG HISTO ----");
        }).subscribe();
        return histogram;
    }

    public Flux<Payload> startPingPong(int count, Recorder histogram) {
        return this.client.flatMapMany(rsocket -> Flux.range((int)1, (int)count).flatMap(i -> {
            long start = System.nanoTime();
            return rsocket.requestResponse(this.payload.retain()).doOnNext(ReferenceCounted::release).doFinally(signalType -> {
                long diff = System.nanoTime() - start;
                histogram.recordValue(diff);
            });
        }, 64)).doOnError(Throwable::printStackTrace);
    }
}

