/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.test;

import io.rsocket.Closeable;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.RSocketFactory;
import io.rsocket.test.SlowTest;
import io.rsocket.test.TestRSocket;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import io.rsocket.util.DefaultPayload;
import java.time.Duration;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public interface TransportTest {
    @AfterEach
    default public void close() {
        this.getTransportPair().dispose();
    }

    default public Payload createTestPayload(int metadataPresent) {
        String metadata1;
        switch (metadataPresent % 5) {
            case 0: {
                metadata1 = null;
                break;
            }
            case 1: {
                metadata1 = "";
                break;
            }
            default: {
                metadata1 = "metadata";
            }
        }
        String metadata = metadata1;
        return DefaultPayload.create((CharSequence)"test-data", (CharSequence)metadata);
    }

    @DisplayName(value="makes 10 fireAndForget requests")
    @Test
    default public void fireAndForget10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().fireAndForget(this.createTestPayload((int)i))).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    default public RSocket getClient() {
        return this.getTransportPair().getClient();
    }

    public Duration getTimeout();

    public TransportPair getTransportPair();

    @DisplayName(value="makes 10 metadataPush requests")
    @Test
    default public void metadataPush10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().metadataPush(DefaultPayload.create((CharSequence)"", (CharSequence)"test-metadata"))).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 0 payloads")
    @Test
    default public void requestChannel0() {
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)Flux.empty()).as(StepVerifier::create)).expectNextCount(0L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 1 payloads")
    @Test
    default public void requestChannel1() {
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)Mono.just((Object)this.createTestPayload(0))).as(StepVerifier::create)).expectNextCount(1L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 200,000 payloads")
    @Test
    default public void requestChannel200_000() {
        Flux payloads = Flux.range((int)0, (int)200000).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(200000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 20,000 payloads")
    @Test
    default public void requestChannel20_000() {
        Flux payloads = Flux.range((int)0, (int)20000).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(20000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 2,000,000 payloads")
    @SlowTest
    default public void requestChannel2_000_000() {
        Flux payloads = Flux.range((int)0, (int)2000000).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(2000000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 3 payloads")
    @Test
    default public void requestChannel3() {
        Flux payloads = Flux.range((int)0, (int)3).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(3L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestChannel request with 512 payloads")
    @Test
    default public void requestChannel512() {
        Flux payloads = Flux.range((int)0, (int)512).map(this::createTestPayload);
        ((StepVerifier.FirstStep)this.getClient().requestChannel((Publisher)payloads).as(StepVerifier::create)).expectNextCount(512L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestResponse request")
    @Test
    default public void requestResponse1() {
        ((StepVerifier.FirstStep)this.getClient().requestResponse(this.createTestPayload(1)).map(Payload::getDataUtf8).as(StepVerifier::create)).expectNextCount(1L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 10 requestResponse requests")
    @Test
    default public void requestResponse10() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10).flatMap(i -> this.getClient().requestResponse(this.createTestPayload((int)i)).map(Payload::getDataUtf8)).as(StepVerifier::create)).expectNextCount(10L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 100 requestResponse requests")
    @Test
    default public void requestResponse100() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)100).flatMap(i -> this.getClient().requestResponse(this.createTestPayload((int)i)).map(Payload::getDataUtf8)).as(StepVerifier::create)).expectNextCount(100L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 10,000 requestResponse requests")
    @Test
    default public void requestResponse10_000() {
        ((StepVerifier.FirstStep)Flux.range((int)1, (int)10000).flatMap(i -> this.getClient().requestResponse(this.createTestPayload((int)i)).map(Payload::getDataUtf8)).as(StepVerifier::create)).expectNextCount(10000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestStream request and receives 10,000 responses")
    @Test
    default public void requestStream10_000() {
        ((StepVerifier.FirstStep)this.getClient().requestStream(this.createTestPayload(3)).as(StepVerifier::create)).expectNextCount(10000L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestStream request and receives 5 responses")
    @Test
    default public void requestStream5() {
        ((StepVerifier.FirstStep)this.getClient().requestStream(this.createTestPayload(3)).take(5L).as(StepVerifier::create)).expectNextCount(5L).expectComplete().verify(this.getTimeout());
    }

    @DisplayName(value="makes 1 requestStream request and consumes result incrementally")
    @Test
    default public void requestStreamDelayedRequestN() {
        ((StepVerifier.FirstStep)this.getClient().requestStream(this.createTestPayload(3)).take(10L).as(StepVerifier::create)).thenRequest(5L).expectNextCount(5L).thenRequest(5L).expectNextCount(5L).expectComplete().verify(this.getTimeout());
    }

    public static final class TransportPair<T, S extends Closeable>
    implements Disposable {
        private final RSocket client;
        private final S server;

        public TransportPair(Supplier<T> addressSupplier, BiFunction<T, S, ClientTransport> clientTransportSupplier, Function<T, ServerTransport<S>> serverTransportSupplier) {
            T address = addressSupplier.get();
            this.server = (Closeable)RSocketFactory.receive().acceptor((setup, sendingSocket) -> Mono.just((Object)((Object)new TestRSocket()))).transport(serverTransportSupplier.apply(address)).start().block();
            this.client = (RSocket)RSocketFactory.connect().transport(clientTransportSupplier.apply(address, this.server)).start().doOnError(Throwable::printStackTrace).block();
        }

        public void dispose() {
            this.server.dispose();
        }

        RSocket getClient() {
            return this.client;
        }
    }
}

