/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.micrometer.observation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.Payload;
import io.rsocket.metadata.CompositeMetadata;
import io.rsocket.metadata.CompositeMetadataCodec;
import io.rsocket.metadata.WellKnownMimeType;
import io.rsocket.util.ByteBufPayload;
import io.rsocket.util.DefaultPayload;
import java.util.HashSet;
import java.util.Set;

final class PayloadUtils {
    private PayloadUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    static CompositeByteBuf cleanTracingMetadata(Payload payload, Set<String> fields) {
        HashSet<String> fieldsWithDefaultZipkin = new HashSet<String>(fields);
        fieldsWithDefaultZipkin.add(WellKnownMimeType.MESSAGE_RSOCKET_TRACING_ZIPKIN.getString());
        CompositeByteBuf metadata = ByteBufAllocator.DEFAULT.compositeBuffer();
        if (payload.hasMetadata()) {
            try {
                CompositeMetadata entries = new CompositeMetadata(payload.metadata(), false);
                for (CompositeMetadata.Entry entry : entries) {
                    if (fieldsWithDefaultZipkin.contains(entry.getMimeType())) continue;
                    CompositeMetadataCodec.encodeAndAddMetadataWithCompression((CompositeByteBuf)metadata, (ByteBufAllocator)ByteBufAllocator.DEFAULT, (String)entry.getMimeType(), (ByteBuf)entry.getContent().retain());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return metadata;
    }

    static Payload payload(Payload payload, CompositeByteBuf metadata) {
        Payload newPayload;
        try {
            newPayload = payload instanceof ByteBufPayload ? ByteBufPayload.create((ByteBuf)payload.data().retain(), (ByteBuf)metadata) : DefaultPayload.create((ByteBuf)payload.data().retain(), (ByteBuf)metadata);
        }
        finally {
            payload.release();
        }
        return newPayload;
    }
}

