/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.stat;

import io.rsocket.stat.Quantile;
import java.util.Random;

public class FrugalQuantile
implements Quantile {
    private final double increment;
    private double quantile;
    private Random rng;
    volatile double estimate;
    int step;
    int sign;

    public FrugalQuantile(double quantile, double increment, Random rng) {
        this.increment = increment;
        this.quantile = quantile;
        this.estimate = 0.0;
        this.step = 1;
        this.sign = 0;
        this.rng = rng;
    }

    public FrugalQuantile(double quantile) {
        this(quantile, 1.0, new Random());
    }

    @Override
    public double estimation() {
        return this.estimate;
    }

    @Override
    public synchronized void insert(double x) {
        if (this.sign == 0) {
            this.estimate = x;
            this.sign = 1;
            return;
        }
        if (x > this.estimate && this.rng.nextDouble() > 1.0 - this.quantile) {
            this.step = (int)((double)this.step + (double)this.sign * this.increment);
            this.estimate = this.step > 0 ? (this.estimate += (double)this.step) : (this.estimate += 1.0);
            if (this.estimate > x) {
                this.step = (int)((double)this.step + (x - this.estimate));
                this.estimate = x;
            }
            if (this.sign < 0) {
                this.step = 1;
            }
            this.sign = 1;
        } else if (x < this.estimate && this.rng.nextDouble() > this.quantile) {
            this.step = (int)((double)this.step - (double)this.sign * this.increment);
            this.estimate = this.step > 0 ? (this.estimate -= (double)this.step) : (this.estimate -= 1.0);
            if (this.estimate < x) {
                this.step = (int)((double)this.step + (this.estimate - x));
                this.estimate = x;
            }
            if (this.sign > 0) {
                this.step = 1;
            }
            this.sign = -1;
        }
    }

    public String toString() {
        return "FrugalQuantile(q=" + this.quantile + ", v=" + this.estimate + ")";
    }
}

