/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.rsocket.Payload;
import io.rsocket.core.FragmentationUtils;

final class PayloadValidationUtils {
    static final String INVALID_PAYLOAD_ERROR_MESSAGE = "The payload is too big to be send as a single frame with a max frame length %s. Consider enabling fragmentation.";

    PayloadValidationUtils() {
    }

    static boolean isValid(int mtu, int maxFrameLength, Payload payload, boolean hasInitialRequestN) {
        int unitSize;
        if (mtu > 0) {
            return true;
        }
        boolean hasMetadata = payload.hasMetadata();
        ByteBuf data = payload.data();
        if (hasMetadata) {
            ByteBuf metadata = payload.metadata();
            unitSize = (hasInitialRequestN ? FragmentationUtils.FRAME_OFFSET_WITH_METADATA_AND_INITIAL_REQUEST_N : FragmentationUtils.FRAME_OFFSET_WITH_METADATA) + metadata.readableBytes() + data.readableBytes();
        } else {
            unitSize = (hasInitialRequestN ? FragmentationUtils.FRAME_OFFSET_WITH_INITIAL_REQUEST_N : FragmentationUtils.FRAME_OFFSET) + data.readableBytes();
        }
        return unitSize <= maxFrameLength;
    }

    static boolean isValidMetadata(int maxFrameLength, ByteBuf metadata) {
        return FragmentationUtils.FRAME_OFFSET + metadata.readableBytes() <= maxFrameLength;
    }

    static void assertValidateSetup(int maxFrameLength, int maxInboundPayloadSize, int mtu) {
        if (maxFrameLength > 0xFFFFFF) {
            throw new IllegalArgumentException("Configured maxFrameLength[" + maxFrameLength + "] exceeds maxFrameLength limit " + 0xFFFFFF);
        }
        if (maxFrameLength > maxInboundPayloadSize) {
            throw new IllegalArgumentException("Configured maxFrameLength[" + maxFrameLength + "] exceeds maxPayloadSize[" + maxInboundPayloadSize + "]");
        }
        if (mtu != 0 && mtu > maxFrameLength) {
            throw new IllegalArgumentException("Configured maximumTransmissionUnit[" + mtu + "] exceeds configured maxFrameLength[" + maxFrameLength + "]");
        }
    }
}

