/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.resume;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.rsocket.resume.ServerRSocketSession;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.util.annotation.Nullable;

public class SessionManager {
    static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private volatile boolean isDisposed;
    private final Map<String, ServerRSocketSession> sessions = new ConcurrentHashMap<String, ServerRSocketSession>();

    public ServerRSocketSession save(ServerRSocketSession session, ByteBuf resumeToken) {
        if (this.isDisposed) {
            session.dispose();
        } else {
            String token = resumeToken.toString(CharsetUtil.UTF_8);
            session.resumableConnection.onClose().doFinally(__ -> {
                logger.debug("ResumableConnection has been closed. Removing associated session {" + token + "}");
                if (this.isDisposed || this.sessions.get(token) == session) {
                    this.sessions.remove(token);
                }
            }).subscribe();
            ServerRSocketSession prevSession = this.sessions.remove(token);
            if (prevSession != null) {
                prevSession.dispose();
            }
            this.sessions.put(token, session);
        }
        return session;
    }

    @Nullable
    public ServerRSocketSession get(ByteBuf resumeToken) {
        return this.sessions.get(resumeToken.toString(CharsetUtil.UTF_8));
    }

    public void dispose() {
        this.isDisposed = true;
        this.sessions.values().forEach(ServerRSocketSession::dispose);
    }
}

