/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.rsocket.metadata.TracingMetadata;

public class TracingMetadataCodec {
    static final int FLAG_EXTENDED_TRACE_ID_SIZE = 8;
    static final int FLAG_INCLUDE_PARENT_ID = 4;
    static final int FLAG_NOT_SAMPLED = 16;
    static final int FLAG_SAMPLED = 32;
    static final int FLAG_DEBUG = 64;
    static final int FLAG_IDS_SET = 128;

    public static ByteBuf encodeEmpty(ByteBufAllocator allocator, Flags flag) {
        return TracingMetadataCodec.encode(allocator, true, 0L, 0L, false, 0L, 0L, false, flag);
    }

    public static ByteBuf encode128(ByteBufAllocator allocator, long traceIdHigh, long traceId, long spanId, long parentId, Flags flag) {
        return TracingMetadataCodec.encode(allocator, false, traceIdHigh, traceId, true, spanId, parentId, true, flag);
    }

    public static ByteBuf encode128(ByteBufAllocator allocator, long traceIdHigh, long traceId, long spanId, Flags flag) {
        return TracingMetadataCodec.encode(allocator, false, traceIdHigh, traceId, true, spanId, 0L, false, flag);
    }

    public static ByteBuf encode64(ByteBufAllocator allocator, long traceId, long spanId, long parentId, Flags flag) {
        return TracingMetadataCodec.encode(allocator, false, 0L, traceId, false, spanId, parentId, true, flag);
    }

    public static ByteBuf encode64(ByteBufAllocator allocator, long traceId, long spanId, Flags flag) {
        return TracingMetadataCodec.encode(allocator, false, 0L, traceId, false, spanId, 0L, false, flag);
    }

    static ByteBuf encode(ByteBufAllocator allocator, boolean isEmpty, long traceIdHigh, long traceId, boolean extendedTraceId, long spanId, long parentId, boolean includesParent, Flags flag) {
        int size = 1 + (isEmpty ? 0 : 16 + (extendedTraceId ? 8 : 0) + (includesParent ? 8 : 0));
        ByteBuf buffer = allocator.buffer(size);
        int byteFlags = 0;
        switch (flag) {
            case NOT_SAMPLE: {
                byteFlags |= 0x10;
                break;
            }
            case SAMPLE: {
                byteFlags |= 0x20;
                break;
            }
            case DEBUG: {
                byteFlags |= 0x40;
            }
        }
        if (isEmpty) {
            return buffer.writeByte(byteFlags);
        }
        byteFlags |= 0x80;
        if (extendedTraceId) {
            byteFlags |= 8;
        }
        if (includesParent) {
            byteFlags |= 4;
        }
        buffer.writeByte(byteFlags);
        if (extendedTraceId) {
            buffer.writeLong(traceIdHigh);
        }
        buffer.writeLong(traceId).writeLong(spanId);
        if (includesParent) {
            buffer.writeLong(parentId);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TracingMetadata decode(ByteBuf byteBuf) {
        byteBuf.markReaderIndex();
        try {
            boolean isIDSet;
            byte flags = byteBuf.readByte();
            boolean isNotSampled = (flags & 0x10) == 16;
            boolean isSampled = (flags & 0x20) == 32;
            boolean isDebug = (flags & 0x40) == 64;
            boolean bl = isIDSet = (flags & 0x80) == 128;
            if (!isIDSet) {
                TracingMetadata tracingMetadata = new TracingMetadata(0L, 0L, 0L, false, 0L, true, isNotSampled, isSampled, isDebug);
                return tracingMetadata;
            }
            boolean extendedTraceId = (flags & 8) == 8;
            long traceIdHigh = extendedTraceId ? byteBuf.readLong() : 0L;
            long traceId = byteBuf.readLong();
            long spanId = byteBuf.readLong();
            boolean includesParent = (flags & 4) == 4;
            long parentId = includesParent ? byteBuf.readLong() : 0L;
            TracingMetadata tracingMetadata = new TracingMetadata(traceIdHigh, traceId, spanId, includesParent, parentId, false, isNotSampled, isSampled, isDebug);
            return tracingMetadata;
        }
        finally {
            byteBuf.resetReaderIndex();
        }
    }

    public static enum Flags {
        UNDECIDED,
        NOT_SAMPLE,
        SAMPLE,
        DEBUG;

    }
}

