/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.core.PayloadValidationUtils;
import io.rsocket.core.RequestOperator;
import io.rsocket.core.StreamIdSupplier;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.frame.CancelFrameCodec;
import io.rsocket.frame.ErrorFrameCodec;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.MetadataPushFrameCodec;
import io.rsocket.frame.PayloadFrameCodec;
import io.rsocket.frame.RequestChannelFrameCodec;
import io.rsocket.frame.RequestFireAndForgetFrameCodec;
import io.rsocket.frame.RequestNFrameCodec;
import io.rsocket.frame.RequestResponseFrameCodec;
import io.rsocket.frame.RequestStreamFrameCodec;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.SynchronizedIntObjectHashMap;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.keepalive.KeepAliveFramesAcceptor;
import io.rsocket.keepalive.KeepAliveHandler;
import io.rsocket.keepalive.KeepAliveSupport;
import io.rsocket.lease.RequesterLeaseHandler;
import java.nio.channels.ClosedChannelException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CorePublisher;
import reactor.core.Exceptions;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.util.annotation.Nullable;
import reactor.util.concurrent.Queues;

class RSocketRequester
implements RSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSocketRequester.class);
    private static final Exception CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    private static final Consumer<ReferenceCounted> DROPPED_ELEMENTS_CONSUMER = referenceCounted -> {
        if (referenceCounted.refCnt() > 0) {
            try {
                referenceCounted.release();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    };
    private volatile Throwable terminationError;
    private static final AtomicReferenceFieldUpdater<RSocketRequester, Throwable> TERMINATION_ERROR;
    private final DuplexConnection connection;
    private final PayloadDecoder payloadDecoder;
    private final StreamIdSupplier streamIdSupplier;
    private final IntObjectMap<Subscription> senders;
    private final IntObjectMap<Processor<Payload, Payload>> receivers;
    private final UnboundedProcessor<ByteBuf> sendProcessor;
    private final int mtu;
    private final int maxFrameLength;
    private final RequesterLeaseHandler leaseHandler;
    private final ByteBufAllocator allocator;
    private final KeepAliveFramesAcceptor keepAliveFramesAcceptor;
    private final MonoProcessor<Void> onClose;
    private final Scheduler serialScheduler;

    RSocketRequester(DuplexConnection connection, PayloadDecoder payloadDecoder, StreamIdSupplier streamIdSupplier, int mtu, int maxFrameLength, int keepAliveTickPeriod, int keepAliveAckTimeout, @Nullable KeepAliveHandler keepAliveHandler, RequesterLeaseHandler leaseHandler, Scheduler serialScheduler) {
        this.connection = connection;
        this.allocator = connection.alloc();
        this.payloadDecoder = payloadDecoder;
        this.streamIdSupplier = streamIdSupplier;
        this.mtu = mtu;
        this.maxFrameLength = maxFrameLength;
        this.leaseHandler = leaseHandler;
        this.senders = new SynchronizedIntObjectHashMap<Subscription>();
        this.receivers = new SynchronizedIntObjectHashMap<Processor<Payload, Payload>>();
        this.onClose = MonoProcessor.create();
        this.serialScheduler = serialScheduler;
        this.sendProcessor = new UnboundedProcessor();
        connection.onClose().subscribe(null, this::tryTerminateOnConnectionError, this::tryShutdown);
        connection.send((Publisher<ByteBuf>)this.sendProcessor).subscribe(null, this::handleSendProcessorError);
        connection.receive().subscribe(this::handleIncomingFrames, e -> {});
        if (keepAliveTickPeriod != 0 && keepAliveHandler != null) {
            KeepAliveSupport.ClientKeepAliveSupport keepAliveSupport = new KeepAliveSupport.ClientKeepAliveSupport(this.allocator, keepAliveTickPeriod, keepAliveAckTimeout);
            this.keepAliveFramesAcceptor = keepAliveHandler.start(keepAliveSupport, this.sendProcessor::onNextPrioritized, this::tryTerminateOnKeepAlive);
        } else {
            this.keepAliveFramesAcceptor = null;
        }
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        return this.handleFireAndForget(payload);
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        return this.handleRequestResponse(payload);
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        return this.handleRequestStream(payload);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.handleChannel((Flux<Payload>)Flux.from(payloads));
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        return this.handleMetadataPush(payload);
    }

    @Override
    public double availability() {
        return Math.min(this.connection.availability(), this.leaseHandler.availability());
    }

    @Override
    public void dispose() {
        this.tryShutdown();
    }

    @Override
    public boolean isDisposed() {
        return this.terminationError != null;
    }

    @Override
    public Mono<Void> onClose() {
        return this.onClose;
    }

    private Mono<Void> handleFireAndForget(Payload payload) {
        if (payload.refCnt() <= 0) {
            return Mono.error((Throwable)new IllegalReferenceCountException());
        }
        if (this.isDisposed()) {
            payload.release();
            Throwable t = this.terminationError;
            return Mono.error((Throwable)t);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload, this.maxFrameLength)) {
            payload.release();
            return Mono.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        AtomicBoolean once = new AtomicBoolean();
        return Mono.defer(() -> {
            if (once.getAndSet(true)) {
                return Mono.error((Throwable)new IllegalStateException("FireAndForgetMono allows only a single subscriber"));
            }
            if (this.isDisposed()) {
                payload.release();
                Throwable t = this.terminationError;
                return Mono.error((Throwable)t);
            }
            RequesterLeaseHandler lh = this.leaseHandler;
            if (!lh.useLease()) {
                payload.release();
                return Mono.error((Throwable)lh.leaseError());
            }
            int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
            ByteBuf requestFrame = RequestFireAndForgetFrameCodec.encodeReleasingPayload(this.allocator, streamId, payload);
            this.sendProcessor.onNext(requestFrame);
            return Mono.empty();
        }).subscribeOn(this.serialScheduler);
    }

    private Mono<Payload> handleRequestResponse(final Payload payload) {
        if (payload.refCnt() <= 0) {
            return Mono.error((Throwable)new IllegalReferenceCountException());
        }
        if (this.isDisposed()) {
            payload.release();
            Throwable t = this.terminationError;
            return Mono.error((Throwable)t);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload, this.maxFrameLength)) {
            payload.release();
            return Mono.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final UnicastProcessor receiver = UnicastProcessor.create((Queue)((Queue)Queues.one().get()));
        return Mono.fromDirect((Publisher)new RequestOperator((CorePublisher)receiver.next(), "RequestResponseMono allows only a single subscriber"){

            @Override
            void hookOnFirstRequest(long n) {
                int streamId;
                if (RSocketRequester.this.isDisposed()) {
                    payload.release();
                    Throwable t = RSocketRequester.this.terminationError;
                    receiver.onError(t);
                    return;
                }
                RequesterLeaseHandler lh = RSocketRequester.this.leaseHandler;
                if (!lh.useLease()) {
                    payload.release();
                    receiver.onError((Throwable)lh.leaseError());
                    return;
                }
                this.streamId = streamId = RSocketRequester.this.streamIdSupplier.nextStreamId(RSocketRequester.this.receivers);
                ByteBuf requestResponseFrame = RequestResponseFrameCodec.encodeReleasingPayload(RSocketRequester.this.allocator, streamId, payload);
                RSocketRequester.this.receivers.put(streamId, (Object)receiver);
                sendProcessor.onNext(requestResponseFrame);
            }

            @Override
            void hookOnCancel() {
                if (RSocketRequester.this.receivers.remove((Object)this.streamId, (Object)receiver)) {
                    sendProcessor.onNext(CancelFrameCodec.encode(RSocketRequester.this.allocator, this.streamId));
                } else if (this.firstRequest) {
                    payload.release();
                }
            }

            @Override
            public void hookOnTerminal(SignalType signalType) {
                RSocketRequester.this.receivers.remove((Object)this.streamId, (Object)receiver);
            }
        }).subscribeOn(this.serialScheduler).doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER);
    }

    private Flux<Payload> handleRequestStream(final Payload payload) {
        if (payload.refCnt() <= 0) {
            return Flux.error((Throwable)new IllegalReferenceCountException());
        }
        if (this.isDisposed()) {
            payload.release();
            Throwable t = this.terminationError;
            return Flux.error((Throwable)t);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload, this.maxFrameLength)) {
            payload.release();
            return Flux.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final UnicastProcessor receiver = UnicastProcessor.create((Queue)((Queue)Queues.one().get()));
        return Flux.from((Publisher)new RequestOperator((CorePublisher)receiver, "RequestStreamFlux allows only a single subscriber"){

            @Override
            void hookOnFirstRequest(long n) {
                int streamId;
                if (RSocketRequester.this.isDisposed()) {
                    payload.release();
                    Throwable t = RSocketRequester.this.terminationError;
                    receiver.onError(t);
                    return;
                }
                RequesterLeaseHandler lh = RSocketRequester.this.leaseHandler;
                if (!lh.useLease()) {
                    payload.release();
                    receiver.onError((Throwable)lh.leaseError());
                    return;
                }
                this.streamId = streamId = RSocketRequester.this.streamIdSupplier.nextStreamId(RSocketRequester.this.receivers);
                ByteBuf requestStreamFrame = RequestStreamFrameCodec.encodeReleasingPayload(RSocketRequester.this.allocator, streamId, n, payload);
                RSocketRequester.this.receivers.put(streamId, (Object)receiver);
                sendProcessor.onNext(requestStreamFrame);
            }

            @Override
            void hookOnRemainingRequests(long n) {
                if (receiver.isDisposed()) {
                    return;
                }
                sendProcessor.onNext(RequestNFrameCodec.encode(RSocketRequester.this.allocator, this.streamId, n));
            }

            @Override
            void hookOnCancel() {
                if (RSocketRequester.this.receivers.remove((Object)this.streamId, (Object)receiver)) {
                    sendProcessor.onNext(CancelFrameCodec.encode(RSocketRequester.this.allocator, this.streamId));
                } else if (this.firstRequest) {
                    payload.release();
                }
            }

            @Override
            void hookOnTerminal(SignalType signalType) {
                RSocketRequester.this.receivers.remove(this.streamId);
            }
        }).subscribeOn(this.serialScheduler, false).doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER);
    }

    private Flux<Payload> handleChannel(Flux<Payload> request) {
        if (this.isDisposed()) {
            Throwable t = this.terminationError;
            return Flux.error((Throwable)t);
        }
        return request.switchOnFirst((s, flux) -> {
            Payload payload = (Payload)s.get();
            if (payload != null) {
                if (payload.refCnt() <= 0) {
                    return Mono.error((Throwable)new IllegalReferenceCountException());
                }
                if (!PayloadValidationUtils.isValid(this.mtu, payload, this.maxFrameLength)) {
                    payload.release();
                    IllegalArgumentException t = new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory.");
                    return Mono.error((Throwable)t);
                }
                return this.handleChannel(payload, (Flux<Payload>)flux);
            }
            return flux;
        }, false).doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER);
    }

    private Flux<? extends Payload> handleChannel(final Payload initialPayload, final Flux<Payload> inboundFlux) {
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final UnicastProcessor receiver = UnicastProcessor.create((Queue)((Queue)Queues.one().get()));
        return Flux.from((Publisher)new RequestOperator((CorePublisher)receiver, "RequestStreamFlux allows only a single subscriber"){
            final BaseSubscriber<Payload> upstreamSubscriber;
            {
                super((CorePublisher<Payload>)source, errorMessageOnSecondSubscription);
                this.upstreamSubscriber = new BaseSubscriber<Payload>(){
                    boolean first = true;

                    protected void hookOnSubscribe(Subscription subscription) {
                    }

                    protected void hookOnNext(Payload payload) {
                        if (this.first) {
                            this.first = false;
                            this.request(1L);
                            return;
                        }
                        if (!PayloadValidationUtils.isValid(RSocketRequester.this.mtu, payload, RSocketRequester.this.maxFrameLength)) {
                            payload.release();
                            this.cancel();
                            IllegalArgumentException t = new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory.");
                            sendProcessor.onNext(CancelFrameCodec.encode(RSocketRequester.this.allocator, streamId));
                            receiver.onError((Throwable)t);
                            return;
                        }
                        ByteBuf frame = PayloadFrameCodec.encodeNextReleasingPayload(RSocketRequester.this.allocator, streamId, payload);
                        sendProcessor.onNext(frame);
                    }

                    protected void hookOnComplete() {
                        ByteBuf frame = PayloadFrameCodec.encodeComplete(RSocketRequester.this.allocator, streamId);
                        sendProcessor.onNext(frame);
                    }

                    protected void hookOnError(Throwable t) {
                        ByteBuf frame = ErrorFrameCodec.encode(RSocketRequester.this.allocator, streamId, t);
                        sendProcessor.onNext(frame);
                        receiver.onError(t);
                    }

                    protected void hookFinally(SignalType type) {
                        RSocketRequester.this.senders.remove((Object)streamId, (Object)this);
                    }
                };
            }

            @Override
            void hookOnFirstRequest(long n) {
                int streamId;
                if (RSocketRequester.this.isDisposed()) {
                    initialPayload.release();
                    Throwable t = RSocketRequester.this.terminationError;
                    this.upstreamSubscriber.cancel();
                    receiver.onError(t);
                    return;
                }
                RequesterLeaseHandler lh = RSocketRequester.this.leaseHandler;
                if (!lh.useLease()) {
                    initialPayload.release();
                    receiver.onError((Throwable)lh.leaseError());
                    return;
                }
                this.streamId = streamId = RSocketRequester.this.streamIdSupplier.nextStreamId(RSocketRequester.this.receivers);
                ByteBuf frame = RequestChannelFrameCodec.encodeReleasingPayload(RSocketRequester.this.allocator, streamId, false, n, initialPayload);
                RSocketRequester.this.senders.put(streamId, this.upstreamSubscriber);
                RSocketRequester.this.receivers.put(streamId, (Object)receiver);
                inboundFlux.doOnDiscard(ReferenceCounted.class, DROPPED_ELEMENTS_CONSUMER).subscribe(this.upstreamSubscriber);
                sendProcessor.onNext(frame);
            }

            @Override
            void hookOnRemainingRequests(long n) {
                if (receiver.isDisposed()) {
                    return;
                }
                sendProcessor.onNext(RequestNFrameCodec.encode(RSocketRequester.this.allocator, this.streamId, n));
            }

            @Override
            void hookOnCancel() {
                RSocketRequester.this.senders.remove((Object)this.streamId, this.upstreamSubscriber);
                if (RSocketRequester.this.receivers.remove((Object)this.streamId, (Object)receiver)) {
                    sendProcessor.onNext(CancelFrameCodec.encode(RSocketRequester.this.allocator, this.streamId));
                }
            }

            @Override
            void hookOnTerminal(SignalType signalType) {
                if (signalType == SignalType.ON_ERROR) {
                    this.upstreamSubscriber.cancel();
                }
                RSocketRequester.this.receivers.remove((Object)this.streamId, (Object)receiver);
            }

            @Override
            public void cancel() {
                this.upstreamSubscriber.cancel();
                super.cancel();
            }
        }).subscribeOn(this.serialScheduler, false);
    }

    private Mono<Void> handleMetadataPush(Payload payload) {
        if (payload.refCnt() <= 0) {
            return Mono.error((Throwable)new IllegalReferenceCountException());
        }
        if (this.isDisposed()) {
            Throwable err = this.terminationError;
            payload.release();
            return Mono.error((Throwable)err);
        }
        if (!PayloadValidationUtils.isValid(this.mtu, payload, this.maxFrameLength)) {
            payload.release();
            return Mono.error((Throwable)new IllegalArgumentException("The payload is too big to send as a single frame with a 24-bit encoded length. Consider enabling fragmentation via RSocketFactory."));
        }
        AtomicBoolean once = new AtomicBoolean();
        return Mono.defer(() -> {
            if (once.getAndSet(true)) {
                return Mono.error((Throwable)new IllegalStateException("MetadataPushMono allows only a single subscriber"));
            }
            if (this.isDisposed()) {
                payload.release();
                Throwable t = this.terminationError;
                return Mono.error((Throwable)t);
            }
            ByteBuf metadataPushFrame = MetadataPushFrameCodec.encodeReleasingPayload(this.allocator, payload);
            this.sendProcessor.onNextPrioritized(metadataPushFrame);
            return Mono.empty();
        });
    }

    private void handleIncomingFrames(ByteBuf frame) {
        try {
            int streamId = FrameHeaderCodec.streamId(frame);
            FrameType type = FrameHeaderCodec.frameType(frame);
            if (streamId == 0) {
                this.handleStreamZero(type, frame);
            } else {
                this.handleFrame(streamId, type, frame);
            }
            frame.release();
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)frame);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    private void handleStreamZero(FrameType type, ByteBuf frame) {
        switch (type) {
            case ERROR: {
                this.tryTerminateOnZeroError(frame);
                break;
            }
            case LEASE: {
                this.leaseHandler.receive(frame);
                break;
            }
            case KEEPALIVE: {
                if (this.keepAliveFramesAcceptor == null) break;
                this.keepAliveFramesAcceptor.receive(frame);
                break;
            }
            default: {
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("Requester received unsupported frame on stream 0: " + frame.toString());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleFrame(int streamId, FrameType type, ByteBuf frame) {
        receiver = (Subscriber)this.receivers.get(streamId);
        switch (4.$SwitchMap$io$rsocket$frame$FrameType[type.ordinal()]) {
            case 4: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onNext(this.payloadDecoder.apply(frame));
                break;
            }
            case 5: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onNext(this.payloadDecoder.apply(frame));
                receiver.onComplete();
                break;
            }
            case 6: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                receiver.onComplete();
                this.receivers.remove(streamId);
                break;
            }
            case 1: {
                if (receiver == null) {
                    this.handleMissingResponseProcessor(streamId, type, frame);
                    return;
                }
                try {
                    receiver.onError((Throwable)io.rsocket.exceptions.Exceptions.from(streamId, frame));
                }
                catch (RuntimeException e) {
                    if (!Exceptions.isBubbling((Throwable)e) && !Exceptions.isErrorCallbackNotImplemented((Throwable)e) || !RSocketRequester.LOGGER.isDebugEnabled()) ** GOTO lbl35
                    unwrapped = Exceptions.unwrap((Throwable)e);
                    RSocketRequester.LOGGER.debug("Unhandled dropped exception", unwrapped);
                }
lbl35:
                // 3 sources

                this.receivers.remove(streamId);
                break;
            }
            case 7: {
                sender = (Subscription)this.senders.remove(streamId);
                if (sender == null) break;
                sender.cancel();
                break;
            }
            case 8: {
                sender = (Subscription)this.senders.get(streamId);
                if (sender == null) break;
                n = RequestNFrameCodec.requestN(frame);
                sender.request(n);
                break;
            }
            default: {
                throw new IllegalStateException("Requester received unsupported frame on stream " + streamId + ": " + frame.toString());
            }
        }
    }

    private void handleMissingResponseProcessor(int streamId, FrameType type, ByteBuf frame) {
        if (!this.streamIdSupplier.isBeforeOrCurrent(streamId)) {
            if (type == FrameType.ERROR) {
                String errorMessage = ErrorFrameCodec.dataUtf8(frame);
                throw new IllegalStateException("Client received error for non-existent stream: " + streamId + " Message: " + errorMessage);
            }
            throw new IllegalStateException("Client received message for non-existent stream: " + streamId + ", frame type: " + (Object)((Object)type));
        }
    }

    private void tryTerminateOnKeepAlive(KeepAliveSupport.KeepAlive keepAlive) {
        this.tryTerminate(() -> new ConnectionErrorException(String.format("No keep-alive acks for %d ms", keepAlive.getTimeout().toMillis())));
    }

    private void tryTerminateOnConnectionError(Throwable e) {
        this.tryTerminate(() -> e);
    }

    private void tryTerminateOnZeroError(ByteBuf errorFrame) {
        this.tryTerminate(() -> io.rsocket.exceptions.Exceptions.from(0, errorFrame));
    }

    private void tryTerminate(Supplier<Throwable> errorSupplier) {
        Throwable e;
        if (this.terminationError == null && TERMINATION_ERROR.compareAndSet(this, null, e = errorSupplier.get())) {
            this.serialScheduler.schedule(() -> this.terminate(e));
        }
    }

    private void tryShutdown() {
        if (this.terminationError == null && TERMINATION_ERROR.compareAndSet(this, null, CLOSED_CHANNEL_EXCEPTION)) {
            this.serialScheduler.schedule(() -> this.terminate(CLOSED_CHANNEL_EXCEPTION));
        }
    }

    private void terminate(Throwable e) {
        if (this.keepAliveFramesAcceptor != null) {
            this.keepAliveFramesAcceptor.dispose();
        }
        this.connection.dispose();
        this.leaseHandler.dispose();
        for (IntObjectMap.PrimitiveEntry entry : this.receivers.entries()) {
            try {
                ((Processor)entry.value()).onError(e);
            }
            catch (Throwable ex) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Dropped exception", ex);
            }
        }
        for (IntObjectMap.PrimitiveEntry entry : this.senders.entries()) {
            try {
                ((Subscription)entry.value()).cancel();
            }
            catch (Throwable ex) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Dropped exception", ex);
            }
        }
        this.senders.clear();
        this.receivers.clear();
        this.sendProcessor.dispose();
        if (e == CLOSED_CHANNEL_EXCEPTION) {
            this.onClose.onComplete();
        } else {
            this.onClose.onError(e);
        }
    }

    private void handleSendProcessorError(Throwable t) {
        this.connection.dispose();
    }

    static {
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(new StackTraceElement[0]);
        TERMINATION_ERROR = AtomicReferenceFieldUpdater.newUpdater(RSocketRequester.class, Throwable.class, "terminationError");
    }
}

