/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.Closeable;
import io.rsocket.ConnectionSetupPayload;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.SocketAcceptor;
import io.rsocket.core.RSocketConnector;
import io.rsocket.core.RSocketServer;
import io.rsocket.core.Resume;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.lease.LeaseStats;
import io.rsocket.lease.Leases;
import io.rsocket.plugins.DuplexConnectionInterceptor;
import io.rsocket.plugins.RSocketInterceptor;
import io.rsocket.plugins.SocketAcceptorInterceptor;
import io.rsocket.resume.ClientResume;
import io.rsocket.resume.ResumableFramesStore;
import io.rsocket.resume.ResumeStrategy;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.ServerTransport;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

@Deprecated
public final class RSocketFactory {
    public static ClientRSocketFactory connect() {
        return new ClientRSocketFactory();
    }

    public static ServerRSocketFactory receive() {
        return new ServerRSocketFactory();
    }

    public static class ServerRSocketFactory
    implements ServerTransportAcceptor {
        private final RSocketServer server;
        private Resume resume;

        public ServerRSocketFactory() {
            this(RSocketServer.create());
        }

        public ServerRSocketFactory(RSocketServer server) {
            this.server = server;
        }

        @Deprecated
        public ServerRSocketFactory byteBufAllocator(ByteBufAllocator allocator) {
            return this;
        }

        public ServerRSocketFactory addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
            this.server.interceptors(registry -> registry.forConnection(interceptor));
            return this;
        }

        @Deprecated
        public ServerRSocketFactory addClientPlugin(RSocketInterceptor interceptor) {
            return this.addRequesterPlugin(interceptor);
        }

        public ServerRSocketFactory addRequesterPlugin(RSocketInterceptor interceptor) {
            this.server.interceptors(registry -> registry.forRequester(interceptor));
            return this;
        }

        @Deprecated
        public ServerRSocketFactory addServerPlugin(RSocketInterceptor interceptor) {
            return this.addResponderPlugin(interceptor);
        }

        public ServerRSocketFactory addResponderPlugin(RSocketInterceptor interceptor) {
            this.server.interceptors(registry -> registry.forResponder(interceptor));
            return this;
        }

        public ServerRSocketFactory addSocketAcceptorPlugin(SocketAcceptorInterceptor interceptor) {
            this.server.interceptors(registry -> registry.forSocketAcceptor(interceptor));
            return this;
        }

        public ServerTransportAcceptor acceptor(SocketAcceptor acceptor) {
            this.server.acceptor(acceptor);
            return this;
        }

        public ServerRSocketFactory frameDecoder(PayloadDecoder payloadDecoder) {
            this.server.payloadDecoder(payloadDecoder);
            return this;
        }

        public ServerRSocketFactory fragment(int mtu) {
            this.server.fragment(mtu);
            return this;
        }

        public ServerRSocketFactory errorConsumer(Consumer<Throwable> errorConsumer) {
            return this;
        }

        public ServerRSocketFactory lease(Supplier<Leases<?>> supplier) {
            this.server.lease(supplier);
            return this;
        }

        public ServerRSocketFactory lease() {
            this.server.lease(Leases::new);
            return this;
        }

        @Deprecated
        public ServerRSocketFactory singleSubscriberRequester() {
            return this;
        }

        public ServerRSocketFactory resume() {
            this.resume = this.resume != null ? this.resume : new Resume();
            this.server.resume(this.resume);
            return this;
        }

        public ServerRSocketFactory resumeStore(Function<? super ByteBuf, ? extends ResumableFramesStore> storeFactory) {
            this.resume();
            this.resume.storeFactory(storeFactory);
            return this;
        }

        public ServerRSocketFactory resumeSessionDuration(Duration sessionDuration) {
            this.resume();
            this.resume.sessionDuration(sessionDuration);
            return this;
        }

        public ServerRSocketFactory resumeStreamTimeout(Duration streamTimeout) {
            this.resume();
            this.resume.streamTimeout(streamTimeout);
            return this;
        }

        public ServerRSocketFactory resumeCleanupOnKeepAlive() {
            this.resume();
            this.resume.cleanupStoreOnKeepAlive();
            return this;
        }

        @Override
        public ServerTransport.ConnectionAcceptor toConnectionAcceptor() {
            return this.server.asConnectionAcceptor();
        }

        @Override
        public <T extends Closeable> Start<T> transport(Supplier<ServerTransport<T>> transport) {
            return () -> this.server.bind((ServerTransport)transport.get());
        }
    }

    public static class ClientRSocketFactory
    implements ClientTransportAcceptor {
        private static final ClientResume CLIENT_RESUME = new ClientResume(Duration.ofMinutes(2L), Unpooled.EMPTY_BUFFER);
        private final RSocketConnector connector;
        private Duration tickPeriod = Duration.ofSeconds(20L);
        private Duration ackTimeout = Duration.ofSeconds(30L);
        private int missedAcks = 3;
        private Resume resume;

        public ClientRSocketFactory() {
            this(RSocketConnector.create());
        }

        public ClientRSocketFactory(RSocketConnector connector) {
            this.connector = connector;
        }

        public ClientRSocketFactory byteBufAllocator(ByteBufAllocator allocator) {
            return this;
        }

        public ClientRSocketFactory addConnectionPlugin(DuplexConnectionInterceptor interceptor) {
            this.connector.interceptors(registry -> registry.forConnection(interceptor));
            return this;
        }

        @Deprecated
        public ClientRSocketFactory addClientPlugin(RSocketInterceptor interceptor) {
            return this.addRequesterPlugin(interceptor);
        }

        public ClientRSocketFactory addRequesterPlugin(RSocketInterceptor interceptor) {
            this.connector.interceptors(registry -> registry.forRequester(interceptor));
            return this;
        }

        @Deprecated
        public ClientRSocketFactory addServerPlugin(RSocketInterceptor interceptor) {
            return this.addResponderPlugin(interceptor);
        }

        public ClientRSocketFactory addResponderPlugin(RSocketInterceptor interceptor) {
            this.connector.interceptors(registry -> registry.forResponder(interceptor));
            return this;
        }

        public ClientRSocketFactory addSocketAcceptorPlugin(SocketAcceptorInterceptor interceptor) {
            this.connector.interceptors(registry -> registry.forSocketAcceptor(interceptor));
            return this;
        }

        @Deprecated
        public ClientRSocketFactory keepAlive() {
            this.connector.keepAlive(this.tickPeriod, this.ackTimeout.plus(this.tickPeriod.multipliedBy(this.missedAcks)));
            return this;
        }

        public ClientTransportAcceptor keepAlive(Duration tickPeriod, Duration ackTimeout, int missedAcks) {
            this.tickPeriod = tickPeriod;
            this.ackTimeout = ackTimeout;
            this.missedAcks = missedAcks;
            this.keepAlive();
            return this;
        }

        public ClientRSocketFactory keepAliveTickPeriod(Duration tickPeriod) {
            this.tickPeriod = tickPeriod;
            this.keepAlive();
            return this;
        }

        public ClientRSocketFactory keepAliveAckTimeout(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            this.keepAlive();
            return this;
        }

        public ClientRSocketFactory keepAliveMissedAcks(int missedAcks) {
            this.missedAcks = missedAcks;
            this.keepAlive();
            return this;
        }

        public ClientRSocketFactory mimeType(String metadataMimeType, String dataMimeType) {
            this.connector.metadataMimeType(metadataMimeType);
            this.connector.dataMimeType(dataMimeType);
            return this;
        }

        public ClientRSocketFactory dataMimeType(String dataMimeType) {
            this.connector.dataMimeType(dataMimeType);
            return this;
        }

        public ClientRSocketFactory metadataMimeType(String metadataMimeType) {
            this.connector.metadataMimeType(metadataMimeType);
            return this;
        }

        public ClientRSocketFactory lease(Supplier<Leases<? extends LeaseStats>> supplier) {
            this.connector.lease(supplier);
            return this;
        }

        public ClientRSocketFactory lease() {
            this.connector.lease(Leases::new);
            return this;
        }

        @Deprecated
        public ClientRSocketFactory singleSubscriberRequester() {
            return this;
        }

        public ClientRSocketFactory reconnect(Retry retrySpec) {
            this.connector.reconnect(retrySpec);
            return this;
        }

        public ClientRSocketFactory resume() {
            this.resume = this.resume != null ? this.resume : new Resume();
            this.connector.resume(this.resume);
            return this;
        }

        public ClientRSocketFactory resumeToken(Supplier<ByteBuf> supplier) {
            this.resume();
            this.resume.token(supplier);
            return this;
        }

        public ClientRSocketFactory resumeStore(Function<? super ByteBuf, ? extends ResumableFramesStore> storeFactory) {
            this.resume();
            this.resume.storeFactory(storeFactory);
            return this;
        }

        public ClientRSocketFactory resumeSessionDuration(Duration sessionDuration) {
            this.resume();
            this.resume.sessionDuration(sessionDuration);
            return this;
        }

        public ClientRSocketFactory resumeStreamTimeout(Duration streamTimeout) {
            this.resume();
            this.resume.streamTimeout(streamTimeout);
            return this;
        }

        public ClientRSocketFactory resumeStrategy(Supplier<ResumeStrategy> strategy) {
            this.resume();
            this.resume.retry(Retry.from(signals -> signals.flatMap(arg_0 -> ClientRSocketFactory.lambda$null$4((Supplier)strategy, arg_0))));
            return this;
        }

        public ClientRSocketFactory resumeCleanupOnKeepAlive() {
            this.resume();
            this.resume.cleanupStoreOnKeepAlive();
            return this;
        }

        @Override
        public Start<RSocket> transport(Supplier<ClientTransport> transport) {
            return () -> this.connector.connect(transport);
        }

        public ClientTransportAcceptor acceptor(Function<RSocket, RSocket> acceptor) {
            return this.acceptor(() -> acceptor);
        }

        public ClientTransportAcceptor acceptor(Supplier<Function<RSocket, RSocket>> acceptorSupplier) {
            return this.acceptor((ConnectionSetupPayload setup, RSocket sendingSocket) -> {
                ((Function)acceptorSupplier.get()).apply(sendingSocket);
                return Mono.empty();
            });
        }

        public ClientTransportAcceptor acceptor(SocketAcceptor acceptor) {
            this.connector.acceptor(acceptor);
            return this;
        }

        public ClientRSocketFactory fragment(int mtu) {
            this.connector.fragment(mtu);
            return this;
        }

        public ClientRSocketFactory errorConsumer(Consumer<Throwable> errorConsumer) {
            return this;
        }

        public ClientRSocketFactory setupPayload(Payload payload) {
            this.connector.setupPayload(payload);
            return this;
        }

        public ClientRSocketFactory frameDecoder(PayloadDecoder payloadDecoder) {
            this.connector.payloadDecoder(payloadDecoder);
            return this;
        }

        private static /* synthetic */ Publisher lambda$null$4(Supplier strategy, Retry.RetrySignal s) {
            return (Publisher)((ResumeStrategy)strategy.get()).apply(CLIENT_RESUME, s.failure());
        }
    }

    public static interface ServerTransportAcceptor {
        public ServerTransport.ConnectionAcceptor toConnectionAcceptor();

        public <T extends Closeable> Start<T> transport(Supplier<ServerTransport<T>> var1);

        default public <T extends Closeable> Start<T> transport(ServerTransport<T> transport) {
            return this.transport(() -> transport);
        }
    }

    public static interface ClientTransportAcceptor {
        public Start<RSocket> transport(Supplier<ClientTransport> var1);

        default public Start<RSocket> transport(ClientTransport transport) {
            return this.transport(() -> transport);
        }
    }

    public static interface Start<T extends Closeable> {
        public Mono<T> start();
    }
}

