/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.metadata;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.rsocket.metadata.CompositeMetadata;
import io.rsocket.metadata.RoutingMetadata;
import io.rsocket.metadata.TaggingMetadata;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class TaggingMetadataFlyweight {
    private static int TAG_LENGTH_MAX = 255;

    public static RoutingMetadata createRoutingMetadata(ByteBufAllocator allocator, Collection<String> tags) {
        return new RoutingMetadata(TaggingMetadataFlyweight.createTaggingContent(allocator, tags));
    }

    public static TaggingMetadata createTaggingMetadata(CompositeMetadata.Entry entry) {
        return new TaggingMetadata(entry.getMimeType(), entry.getContent());
    }

    public static TaggingMetadata createTaggingMetadata(ByteBufAllocator allocator, String knownMimeType, Collection<String> tags) {
        return new TaggingMetadata(knownMimeType, TaggingMetadataFlyweight.createTaggingContent(allocator, tags));
    }

    public static ByteBuf createTaggingContent(ByteBufAllocator allocator, Collection<String> tags) {
        CompositeByteBuf taggingContent = allocator.compositeBuffer();
        for (String key : tags) {
            int length = ByteBufUtil.utf8Bytes((CharSequence)key);
            if (length == 0 || length > TAG_LENGTH_MAX) continue;
            ByteBuf byteBuf = allocator.buffer().writeByte(length);
            byteBuf.writeCharSequence((CharSequence)key, StandardCharsets.UTF_8);
            taggingContent.addComponent(true, byteBuf);
        }
        return taggingContent;
    }
}

