/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.keepalive;

import io.netty.buffer.ByteBuf;
import io.rsocket.Closeable;
import io.rsocket.keepalive.KeepAliveFramesAcceptor;
import io.rsocket.keepalive.KeepAliveSupport;
import io.rsocket.resume.ResumableDuplexConnection;
import java.util.function.Consumer;

public interface KeepAliveHandler {
    public KeepAliveFramesAcceptor start(KeepAliveSupport var1, Consumer<ByteBuf> var2, Consumer<KeepAliveSupport.KeepAlive> var3);

    public static class ResumableKeepAliveHandler
    implements KeepAliveHandler {
        private final ResumableDuplexConnection resumableDuplexConnection;

        public ResumableKeepAliveHandler(ResumableDuplexConnection resumableDuplexConnection) {
            this.resumableDuplexConnection = resumableDuplexConnection;
        }

        @Override
        public KeepAliveFramesAcceptor start(KeepAliveSupport keepAliveSupport, Consumer<ByteBuf> onSendKeepAliveFrame, Consumer<KeepAliveSupport.KeepAlive> onTimeout) {
            this.resumableDuplexConnection.onResume(keepAliveSupport::start);
            this.resumableDuplexConnection.onDisconnect(keepAliveSupport::stop);
            return keepAliveSupport.resumeState(this.resumableDuplexConnection).onSendKeepAliveFrame(onSendKeepAliveFrame).onTimeout(keepAlive -> this.resumableDuplexConnection.disconnect()).start();
        }
    }

    public static class DefaultKeepAliveHandler
    implements KeepAliveHandler {
        private final Closeable duplexConnection;

        public DefaultKeepAliveHandler(Closeable duplexConnection) {
            this.duplexConnection = duplexConnection;
        }

        @Override
        public KeepAliveFramesAcceptor start(KeepAliveSupport keepAliveSupport, Consumer<ByteBuf> onSendKeepAliveFrame, Consumer<KeepAliveSupport.KeepAlive> onTimeout) {
            this.duplexConnection.onClose().doFinally(s -> keepAliveSupport.stop()).subscribe();
            return keepAliveSupport.onSendKeepAliveFrame(onSendKeepAliveFrame).onTimeout(onTimeout).start();
        }
    }
}

