/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.internal;

import io.rsocket.internal.UnboundedProcessor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

public final class SwitchTransform<T, R>
extends Flux<R> {
    final Publisher<? extends T> source;
    final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;

    public SwitchTransform(Publisher<? extends T> source, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
        this.source = Objects.requireNonNull(source, "source");
        this.transformer = Objects.requireNonNull(transformer, "transformer");
    }

    public void subscribe(CoreSubscriber<? super R> actual) {
        Flux.from(this.source).subscribe(new SwitchTransformSubscriber<T, R>(actual, this.transformer));
    }

    static final class SwitchTransformSubscriber<T, R>
    implements CoreSubscriber<T> {
        static final AtomicIntegerFieldUpdater<SwitchTransformSubscriber> ONCE = AtomicIntegerFieldUpdater.newUpdater(SwitchTransformSubscriber.class, "once");
        final CoreSubscriber<? super R> actual;
        final BiFunction<T, Flux<T>, Publisher<? extends R>> transformer;
        final UnboundedProcessor<T> processor = new UnboundedProcessor();
        Subscription s;
        volatile int once;

        SwitchTransformSubscriber(CoreSubscriber<? super R> actual, BiFunction<T, Flux<T>, Publisher<? extends R>> transformer) {
            this.actual = actual;
            this.transformer = transformer;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate((Subscription)this.s, (Subscription)s)) {
                this.s = s;
                this.processor.onSubscribe(s);
            }
        }

        public void onNext(T t) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                try {
                    Publisher<? extends R> result = Objects.requireNonNull(this.transformer.apply(t, (Flux<T>)this.processor), "The transformer returned a null value");
                    Flux.from(result).subscribe(this.actual);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError((Subscription)this.s, (Throwable)e, t, (Context)this.actual.currentContext()));
                    return;
                }
            }
            this.processor.onNext(t);
        }

        public void onError(Throwable t) {
            this.processor.onError(t);
        }

        public void onComplete() {
            this.processor.onComplete();
        }
    }
}

