/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.rsocket.FrameType;
import io.rsocket.frame.FrameHeaderFlyweight;

public class RequestNFrameFlyweight {
    private static final int REQUEST_N_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;

    private RequestNFrameFlyweight() {
    }

    public static int computeFrameLength() {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.REQUEST_N, 0, 0);
        return length + 4;
    }

    public static int encode(ByteBuf byteBuf, int streamId, int requestN) {
        int frameLength = RequestNFrameFlyweight.computeFrameLength();
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, 0, FrameType.REQUEST_N, streamId);
        byteBuf.setInt(REQUEST_N_FIELD_OFFSET, requestN);
        return length + 4;
    }

    public static int requestN(ByteBuf byteBuf) {
        return byteBuf.getInt(REQUEST_N_FIELD_OFFSET);
    }

    public static int payloadOffset(ByteBuf byteBuf) {
        return FrameHeaderFlyweight.FRAME_HEADER_LENGTH + 4;
    }
}

