/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.rsocket.Frame;
import io.rsocket.FrameType;
import io.rsocket.frame.FrameHeaderFlyweight;
import javax.annotation.Nullable;

public class RequestFrameFlyweight {
    private static final int INITIAL_REQUEST_N_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;

    private RequestFrameFlyweight() {
    }

    public static int computeFrameLength(FrameType type, @Nullable Integer metadataLength, int dataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(type, metadataLength, dataLength);
        if (type.hasInitialRequestN()) {
            length += 4;
        }
        return length;
    }

    public static int encode(ByteBuf byteBuf, int streamId, int flags, FrameType type, int initialRequestN, @Nullable ByteBuf metadata, ByteBuf data) {
        if (Frame.isFlagSet(flags, 256) != (metadata != null)) {
            throw new IllegalArgumentException("metadata flag set incorrectly");
        }
        int frameLength = RequestFrameFlyweight.computeFrameLength(type, metadata != null ? Integer.valueOf(metadata.readableBytes()) : null, data.readableBytes());
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, flags, type, streamId);
        byteBuf.setInt(INITIAL_REQUEST_N_FIELD_OFFSET, initialRequestN);
        length += 4;
        length += FrameHeaderFlyweight.encodeMetadata(byteBuf, type, length, metadata);
        length += FrameHeaderFlyweight.encodeData(byteBuf, length, data);
        return length;
    }

    public static int encode(ByteBuf byteBuf, int streamId, int flags, FrameType type, @Nullable ByteBuf metadata, ByteBuf data) {
        if (Frame.isFlagSet(flags, 256) != (metadata != null)) {
            throw new IllegalArgumentException("metadata flag set incorrectly");
        }
        if (type.hasInitialRequestN()) {
            throw new AssertionError((Object)((Object)((Object)type) + " must not be encoded without initial request N"));
        }
        int frameLength = RequestFrameFlyweight.computeFrameLength(type, metadata != null ? Integer.valueOf(metadata.readableBytes()) : null, data.readableBytes());
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, flags, type, streamId);
        length += FrameHeaderFlyweight.encodeMetadata(byteBuf, type, length, metadata);
        length += FrameHeaderFlyweight.encodeData(byteBuf, length, data);
        return length;
    }

    public static int initialRequestN(ByteBuf byteBuf) {
        return byteBuf.getInt(INITIAL_REQUEST_N_FIELD_OFFSET);
    }

    public static int payloadOffset(FrameType type, ByteBuf byteBuf) {
        int result = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
        if (type.hasInitialRequestN()) {
            result += 4;
        }
        return result;
    }
}

