/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.rsocket.FrameType;
import io.rsocket.frame.FrameHeaderFlyweight;

public class LeaseFrameFlyweight {
    private static final int TTL_FIELD_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int NUM_REQUESTS_FIELD_OFFSET = TTL_FIELD_OFFSET + 4;
    private static final int PAYLOAD_OFFSET = NUM_REQUESTS_FIELD_OFFSET + 4;

    private LeaseFrameFlyweight() {
    }

    public static int computeFrameLength(int metadataLength) {
        int length = FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.LEASE, metadataLength, 0);
        return length + 8;
    }

    public static int encode(ByteBuf byteBuf, int ttl, int numRequests, ByteBuf metadata) {
        int frameLength = LeaseFrameFlyweight.computeFrameLength(metadata.readableBytes());
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, 0, FrameType.LEASE, 0);
        byteBuf.setInt(TTL_FIELD_OFFSET, ttl);
        byteBuf.setInt(NUM_REQUESTS_FIELD_OFFSET, numRequests);
        length += 8;
        length += FrameHeaderFlyweight.encodeMetadata(byteBuf, FrameType.LEASE, length, metadata);
        return length;
    }

    public static int ttl(ByteBuf byteBuf) {
        return byteBuf.getInt(TTL_FIELD_OFFSET);
    }

    public static int numRequests(ByteBuf byteBuf) {
        return byteBuf.getInt(NUM_REQUESTS_FIELD_OFFSET);
    }

    public static int payloadOffset(ByteBuf byteBuf) {
        return PAYLOAD_OFFSET;
    }
}

