/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.rsocket.FrameType;
import io.rsocket.frame.FrameHeaderFlyweight;

public class KeepaliveFrameFlyweight {
    public static final int FLAGS_KEEPALIVE_R = 128;
    private static final int LAST_POSITION_OFFSET = FrameHeaderFlyweight.FRAME_HEADER_LENGTH;
    private static final int PAYLOAD_OFFSET = LAST_POSITION_OFFSET + 8;

    private KeepaliveFrameFlyweight() {
    }

    public static int computeFrameLength(int dataLength) {
        return FrameHeaderFlyweight.computeFrameHeaderLength(FrameType.SETUP, null, dataLength) + 8;
    }

    public static int encode(ByteBuf byteBuf, int flags, ByteBuf data) {
        int frameLength = KeepaliveFrameFlyweight.computeFrameLength(data.readableBytes());
        int length = FrameHeaderFlyweight.encodeFrameHeader(byteBuf, frameLength, flags, FrameType.KEEPALIVE, 0);
        byteBuf.setLong(length, 0L);
        length += 8;
        length += FrameHeaderFlyweight.encodeData(byteBuf, length, data);
        return length;
    }

    public static int payloadOffset(ByteBuf byteBuf) {
        return PAYLOAD_OFFSET;
    }
}

