/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.rsocket.Frame;
import io.rsocket.FrameType;
import io.rsocket.frame.FrameHeaderFlyweight;
import reactor.core.Disposable;

public class FrameReassembler
implements Disposable {
    private final FrameType frameType;
    private final int streamId;
    private final int flags;
    private final CompositeByteBuf dataBuffer;
    private final CompositeByteBuf metadataBuffer;

    public FrameReassembler(Frame frame) {
        this.frameType = frame.getType();
        this.streamId = frame.getStreamId();
        this.flags = frame.flags();
        this.dataBuffer = PooledByteBufAllocator.DEFAULT.compositeBuffer();
        this.metadataBuffer = PooledByteBufAllocator.DEFAULT.compositeBuffer();
    }

    public synchronized void append(Frame frame) {
        ByteBuf byteBuf = frame.content();
        FrameType frameType = FrameHeaderFlyweight.frameType(byteBuf);
        int frameLength = FrameHeaderFlyweight.frameLength(byteBuf);
        int metadataLength = FrameHeaderFlyweight.metadataLength(byteBuf, frameType, frameLength);
        int dataLength = FrameHeaderFlyweight.dataLength(byteBuf, frameType);
        if (0 < metadataLength) {
            int metadataOffset = FrameHeaderFlyweight.metadataOffset(byteBuf);
            if (FrameHeaderFlyweight.hasMetadataLengthField(frameType)) {
                metadataOffset += 3;
            }
            this.metadataBuffer.addComponent(true, byteBuf.slice(metadataOffset, metadataLength));
        }
        if (0 < dataLength) {
            int dataOffset = FrameHeaderFlyweight.dataOffset(byteBuf, frameType, frameLength);
            this.dataBuffer.addComponent(true, byteBuf.slice(dataOffset, dataLength));
        }
    }

    public synchronized Frame reassemble() {
        return Frame.PayloadFrame.from(this.streamId, this.frameType, (ByteBuf)this.metadataBuffer, (ByteBuf)this.dataBuffer, this.flags);
    }

    public void dispose() {
        this.dataBuffer.release();
        this.metadataBuffer.release();
    }
}

