/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.fragmentation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.rsocket.Frame;
import io.rsocket.FrameType;
import io.rsocket.frame.FrameHeaderFlyweight;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

public class FrameFragmenter {
    private final int mtu;

    public FrameFragmenter(int mtu) {
        this.mtu = mtu;
    }

    public boolean shouldFragment(Frame frame) {
        return this.isFragmentableFrame(frame.getType()) && FrameHeaderFlyweight.payloadLength(frame.content()) > this.mtu;
    }

    private boolean isFragmentableFrame(FrameType type) {
        switch (type) {
            case FIRE_AND_FORGET: 
            case REQUEST_STREAM: 
            case REQUEST_CHANNEL: 
            case REQUEST_RESPONSE: 
            case PAYLOAD: 
            case NEXT_COMPLETE: 
            case METADATA_PUSH: {
                return true;
            }
        }
        return false;
    }

    public Flux<Frame> fragment(Frame frame) {
        return Flux.generate((Consumer)new FragmentGenerator(frame));
    }

    private class FragmentGenerator
    implements Consumer<SynchronousSink<Frame>> {
        private final Frame frame;
        private final int streamId;
        private final FrameType frameType;
        private final int flags;
        private ByteBuf data;
        @Nullable
        private ByteBuf metadata;

        public FragmentGenerator(Frame frame) {
            this.frame = frame.retain();
            this.streamId = frame.getStreamId();
            this.frameType = frame.getType();
            this.flags = frame.flags() & 0xFFFFFEFF;
            this.metadata = frame.hasMetadata() ? FrameHeaderFlyweight.sliceFrameMetadata(frame.content()) : null;
            this.data = FrameHeaderFlyweight.sliceFrameData(frame.content());
        }

        @Override
        public void accept(SynchronousSink<Frame> sink) {
            int dataLength = this.data.readableBytes();
            if (this.metadata != null) {
                int metadataLength = this.metadata.readableBytes();
                if (metadataLength > FrameFragmenter.this.mtu) {
                    sink.next((Object)Frame.PayloadFrame.from(this.streamId, this.frameType, this.metadata.readSlice(FrameFragmenter.this.mtu), Unpooled.EMPTY_BUFFER, this.flags | 0x100 | 0x80));
                } else if (dataLength > FrameFragmenter.this.mtu - metadataLength) {
                    sink.next((Object)Frame.PayloadFrame.from(this.streamId, this.frameType, this.metadata.readSlice(metadataLength), this.data.readSlice(FrameFragmenter.this.mtu - metadataLength), this.flags | 0x100 | 0x80));
                } else {
                    sink.next((Object)Frame.PayloadFrame.from(this.streamId, this.frameType, this.metadata.readSlice(metadataLength), this.data.readSlice(dataLength), this.flags | 0x100));
                    this.frame.release();
                    sink.complete();
                }
            } else if (dataLength > FrameFragmenter.this.mtu) {
                sink.next((Object)Frame.PayloadFrame.from(this.streamId, this.frameType, Unpooled.EMPTY_BUFFER, this.data.readSlice(FrameFragmenter.this.mtu), this.flags | 0x80));
            } else {
                sink.next((Object)Frame.PayloadFrame.from(this.streamId, this.frameType, Unpooled.EMPTY_BUFFER, this.data.readSlice(dataLength), this.flags));
                this.frame.release();
                sink.complete();
            }
        }
    }
}

