/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.exceptions;

import io.rsocket.Frame;
import io.rsocket.exceptions.ApplicationException;
import io.rsocket.exceptions.CancelException;
import io.rsocket.exceptions.ConnectionCloseException;
import io.rsocket.exceptions.ConnectionException;
import io.rsocket.exceptions.InvalidRequestException;
import io.rsocket.exceptions.InvalidSetupException;
import io.rsocket.exceptions.RejectedException;
import io.rsocket.exceptions.RejectedResumeException;
import io.rsocket.exceptions.RejectedSetupException;
import io.rsocket.exceptions.UnsupportedSetupException;

public class Exceptions {
    private Exceptions() {
    }

    public static RuntimeException from(Frame frame) {
        int errorCode = Frame.Error.errorCode(frame);
        String message = frame.getDataUtf8();
        switch (errorCode) {
            case 513: {
                return new ApplicationException(message);
            }
            case 515: {
                return new CancelException(message);
            }
            case 258: {
                return new ConnectionCloseException(message);
            }
            case 257: {
                return new ConnectionException(message);
            }
            case 516: {
                return new InvalidRequestException(message);
            }
            case 1: {
                return new InvalidSetupException(message);
            }
            case 514: {
                return new RejectedException(message);
            }
            case 4: {
                return new RejectedResumeException(message);
            }
            case 3: {
                return new RejectedSetupException(message);
            }
            case 2: {
                return new UnsupportedSetupException(message);
            }
        }
        return new InvalidRequestException("Invalid Error frame: " + errorCode + " '" + message + "'");
    }
}

